/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.ChartException;
import com.elixirtech.chart2.model.Format;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.PieType;
import com.elixirtech.chart2.model.PieUi;
import com.elixirtech.chart2.model.Value;
import com.elixirtech.chart2.renderer.AbstractChartRenderer;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.chart2.renderer.Formatter;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.text.NumberFormat;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.RingPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class PieRenderer
extends AbstractChartRenderer {
    public static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PieRenderer.class);
    protected PieType m_PieType;

    public PieRenderer(IChart iChart) {
        super(iChart);
        this.m_PieType = (PieType)iChart.getChartType();
    }

    @Override
    public JFreeChart getChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        PiePlot piePlot;
        PieDataset pieDataset;
        PieUi pieUi = this.m_PieType.getPieUi();
        String string = this.m_Chart.getType();
        int n = pieUi.getExplodeSector();
        Dataset dataset = datasetHolder.getDataset();
        Comparable comparable = null;
        float f = 0.0f;
        if ("Pie".equals(string)) {
            f = pieUi.getExplodePercentage() / 100.0f;
            if (f > 0.0f && n >= 0) {
                if (dataset instanceof PieDataset) {
                    pieDataset = (PieDataset)dataset;
                    if (n < pieDataset.getKeys().size()) {
                        comparable = ((PieDataset)dataset).getKey(n);
                    }
                } else if (dataset instanceof CategoryDataset) {
                    comparable = ((CategoryDataset)datasetHolder.getDataset()).getColumnKey(n);
                }
            }
            if (comparable == null) {
                f = 0.0f;
            }
        }
        pieDataset = null;
        if ("Pie".equals(string)) {
            piePlot = new PiePlot((PieDataset)datasetHolder.getDataset());
            piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator());
            this.updateUI(piePlot, pieUi);
            pieDataset = piePlot;
        } else if ("Pie-Ring".equals(string)) {
            piePlot = new RingPlot((PieDataset)datasetHolder.getDataset());
            this.updateUI(piePlot, pieUi);
            pieDataset = piePlot;
        } else if ("Pie-3D".equals(string)) {
            piePlot = new PiePlot3D((PieDataset)datasetHolder.getDataset());
            this.updateUI(piePlot, pieUi);
            pieDataset = piePlot;
        } else if ("Pie-Multi".equals(string)) {
            piePlot = new MultiplePiePlot((CategoryDataset)datasetHolder.getDataset());
            piePlot.setBackgroundPaint(null);
            piePlot.setOutlineStroke(null);
            JFreeChart jFreeChart = new JFreeChart((Plot)new PiePlot(null));
            TextTitle textTitle = new TextTitle("Series Title", new Font("SansSerif", 1, 12));
            textTitle.setPosition(RectangleEdge.BOTTOM);
            jFreeChart.setTitle(textTitle);
            jFreeChart.setBackgroundPaint(null);
            piePlot.setPieChart(jFreeChart);
            PiePlot piePlot2 = (PiePlot)piePlot.getPieChart().getPlot();
            this.updateUI(piePlot2, pieUi);
            pieDataset = piePlot;
        } else if ("Pie-Multi-Ring".equals(string)) {
            piePlot = new MultiplePiePlot((CategoryDataset)datasetHolder.getDataset());
            piePlot.setBackgroundPaint(null);
            piePlot.setOutlineStroke(null);
            JFreeChart jFreeChart = new JFreeChart((Plot)new RingPlot(null));
            TextTitle textTitle = new TextTitle("Series Title", new Font("SansSerif", 1, 12));
            textTitle.setPosition(RectangleEdge.BOTTOM);
            jFreeChart.setTitle(textTitle);
            jFreeChart.setBackgroundPaint(null);
            jFreeChart.removeLegend();
            piePlot.setPieChart(jFreeChart);
            PiePlot piePlot3 = (PiePlot)piePlot.getPieChart().getPlot();
            this.updateUI(piePlot3, pieUi);
            pieDataset = piePlot;
        } else if ("Pie-Multi-3D".equals(string)) {
            piePlot = new MultiplePiePlot((CategoryDataset)datasetHolder.getDataset());
            piePlot.setBackgroundPaint(null);
            piePlot.setOutlineStroke(null);
            JFreeChart jFreeChart = new JFreeChart((Plot)new PiePlot3D(null));
            TextTitle textTitle = new TextTitle("Series Title", new Font("SansSerif", 1, 12));
            textTitle.setPosition(RectangleEdge.BOTTOM);
            jFreeChart.setTitle(textTitle);
            jFreeChart.setBackgroundPaint(null);
            piePlot.setPieChart(jFreeChart);
            PiePlot piePlot4 = (PiePlot)piePlot.getPieChart().getPlot();
            this.updateUI(piePlot4, pieUi);
            pieDataset = piePlot;
        } else {
            throw new ChartException("Unknown chart type," + string);
        }
        assert (pieDataset != null);
        if (pieDataset != null && f > 0.0f) {
            ((PiePlot)pieDataset).setExplodePercent(comparable, (double)f);
        }
        pieDataset.setBackgroundPaint((Paint)StandardColor.lookup(pieUi.getPlotBackground(), (Color)null));
        pieDataset.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        piePlot = new JFreeChart(null, null, (Plot)pieDataset, true);
        piePlot.setBackgroundPaint((Paint)this.m_Chart.getBackgroundColor());
        PieRenderer.setLegend((JFreeChart)piePlot, this.m_PieType.getLegend(), datasetHolder.getLegend());
        PieRenderer.setTitle((JFreeChart)piePlot, this.m_PieType.getTitle(), datasetHolder.getTitle());
        piePlot.setBackgroundPaint(null);
        PieRenderer.processScript(object, (JFreeChart)piePlot, this.m_Chart.getOnConfigure());
        return piePlot;
    }

    private void updateUI(PiePlot piePlot, PieUi pieUi) {
        Value value = pieUi.getValue();
        if (!value.isVisible()) {
            piePlot.setLabelGenerator(null);
            return;
        }
        com.elixirtech.chart2.model.Font font = value.getFont();
        piePlot.setBackgroundPaint((Paint)StandardColor.lookup(pieUi.getPlotBackground(), (Color)null));
        piePlot.setLabelGenerator((PieSectionLabelGenerator)this.getLabelGenerator(pieUi.getLabelFormat(), value));
        piePlot.setLabelBackgroundPaint((Paint)StandardColor.lookup(pieUi.getValueBackground()));
        piePlot.setLabelPaint((Paint)StandardColor.lookup(font.getFontColor()));
        piePlot.setLabelFont(font.getAWTFont());
    }

    private StandardPieSectionLabelGenerator getLabelGenerator(String string, Value value) {
        boolean bl;
        String string2 = string != null ? string : "{0}";
        Format format = (Format)value.getFormat();
        StandardPieSectionLabelGenerator standardPieSectionLabelGenerator = null;
        boolean bl2 = bl = !"None".equals(format.getType());
        if (bl) {
            NumberFormat numberFormat = Formatter.buildNumberFormatter(format, this.m_Chart.getLocale());
            standardPieSectionLabelGenerator = new StandardPieSectionLabelGenerator(string2, numberFormat, NumberFormat.getPercentInstance());
        } else {
            standardPieSectionLabelGenerator = new StandardPieSectionLabelGenerator(string2);
        }
        return standardPieSectionLabelGenerator;
    }
}

