/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jfree.ui.TextAnchor;

public class TextAnchorUtil {
    private static Map<String, TextAnchor> m_Values = new TreeMap<String, TextAnchor>();

    public static TextAnchor lookup(String string) {
        return m_Values.get(string);
    }

    public static String getName(TextAnchor textAnchor) {
        Set<Map.Entry<String, TextAnchor>> set = m_Values.entrySet();
        for (Map.Entry<String, TextAnchor> entry : set) {
            if (entry.getValue() != textAnchor) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String[] names() {
        String[] stringArray = new String[m_Values.size()];
        m_Values.keySet().toArray(stringArray);
        return stringArray;
    }

    public static String[] keys() {
        String[] stringArray = TextAnchorUtil.names();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "Anchor." + stringArray[i].toUpperCase(Locale.ENGLISH).replace(' ', '_');
        }
        return stringArray;
    }

    static {
        m_Values.put("Top Left", TextAnchor.TOP_LEFT);
        m_Values.put("Top Center", TextAnchor.TOP_CENTER);
        m_Values.put("Top Right", TextAnchor.TOP_RIGHT);
        m_Values.put("Half Ascent Left", TextAnchor.HALF_ASCENT_LEFT);
        m_Values.put("Half Ascent Center", TextAnchor.HALF_ASCENT_CENTER);
        m_Values.put("Half Ascent Right", TextAnchor.HALF_ASCENT_RIGHT);
        m_Values.put("Baseline Left", TextAnchor.BASELINE_LEFT);
        m_Values.put("Baseline", TextAnchor.BASELINE_CENTER);
        m_Values.put("Baseline Right", TextAnchor.BASELINE_RIGHT);
    }
}

