/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.sax;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.xml.XMLWriter;
import com.elixirtech.chart2.ChartConstants;
import com.elixirtech.chart2.model.BeanMap;
import com.elixirtech.sax.AbstractSAXOut;
import com.elixirtech.sax.IBaseSAXOut;
import com.elixirtech.sax.IBean;
import com.elixirtech.sax.IBeanSAXOut;
import com.elixirtech.sax.delegates.BaseNumberSAXOut;
import com.elixirtech.sax.delegates.BaseStringSAXOut;
import com.elixirtech.sax.util.EntityResolver;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.ContentHandler;

public class CMLSAXOut
extends AbstractSAXOut {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CMLSAXOut.class);
    private static Map<Class<?>, IBaseSAXOut> m_BaseOutputters = new HashMap();

    public CMLSAXOut(ContentHandler contentHandler, Object object, boolean bl) {
        super(contentHandler, object, bl, ChartConstants.NS_CML);
    }

    public static void process(XMLWriter xMLWriter, IBean iBean, boolean bl) {
        CMLSAXOut cMLSAXOut = new CMLSAXOut(xMLWriter, iBean, bl);
        EntityResolver entityResolver = cMLSAXOut.getEntityResolver();
        if (entityResolver != null) {
            entityResolver.dispose();
        }
    }

    @Override
    public ElxLoggerJ getLog() {
        return m_Log;
    }

    @Override
    protected IBeanSAXOut lookupBeanOutputter(IBean iBean) {
        return BeanMap.getSAXOutputter(iBean);
    }

    @Override
    protected IBaseSAXOut lookupBaseOutputter(Object object) {
        return m_BaseOutputters.get(object.getClass());
    }

    static {
        try {
            m_BaseOutputters.put(String.class, new BaseStringSAXOut());
            BaseNumberSAXOut baseNumberSAXOut = new BaseNumberSAXOut();
            m_BaseOutputters.put(Double.class, baseNumberSAXOut);
            m_BaseOutputters.put(Float.class, baseNumberSAXOut);
            m_BaseOutputters.put(Long.class, baseNumberSAXOut);
            m_BaseOutputters.put(Integer.class, baseNumberSAXOut);
            m_BaseOutputters.put(Short.class, baseNumberSAXOut);
            m_BaseOutputters.put(Byte.class, baseNumberSAXOut);
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't initialize outputters: " + exception), (Throwable)exception);
        }
    }
}

