/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.sax;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.xml.XMLWriter;
import com.elixirtech.chart2.model.Chart;
import com.elixirtech.chart2.model.ChartSAX;
import com.elixirtech.chart2.model.CompositeChart;
import com.elixirtech.chart2.model.CompositeChartSAX;
import com.elixirtech.chart2.sax.CMLSAXOut;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.input.SAXHandler;
import com.elixirtech.jdom.output.SAXOutputter;
import com.elixirtech.repository.RMLFileObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class CMLSAXUtil {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CMLSAXUtil.class);

    public static void writeCML(Chart chart, Writer writer) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("Writer is null");
        }
        XMLWriter xMLWriter = new XMLWriter(writer);
        xMLWriter.setOutput(writer);
        CMLSAXOut.process(xMLWriter, chart, true);
        xMLWriter.flush();
        writer.close();
    }

    public static void writeToRML(Chart chart, com.elixirtech.report2.raw.model.Chart chart2) throws IOException {
        SAXHandler sAXHandler = new SAXHandler();
        sAXHandler.setIgnoringElementContentWhitespace(true);
        new CMLSAXOut(sAXHandler, chart, false);
        chart2.setDocument(sAXHandler.getDocument());
    }

    public static CompositeChart readCompositeChartFromRML(com.elixirtech.report2.raw.model.CompositeChart compositeChart) throws IOException, JDOMException {
        Document document = compositeChart.getDocument();
        CompositeChartSAX compositeChartSAX = new CompositeChartSAX();
        SAXOutputter sAXOutputter = new SAXOutputter(compositeChartSAX);
        sAXOutputter.output(document);
        CompositeChart compositeChart2 = (CompositeChart)compositeChartSAX.getObject();
        compositeChart2.loaded();
        return compositeChart2;
    }

    public static Chart readFromRML(com.elixirtech.report2.raw.model.Chart chart) throws IOException, JDOMException {
        Document document = chart.getDocument();
        ChartSAX chartSAX = new ChartSAX();
        SAXOutputter sAXOutputter = new SAXOutputter(chartSAX);
        sAXOutputter.output(document);
        Chart chart2 = (Chart)chartSAX.getObject();
        chart2.loaded();
        return chart2;
    }

    public static Chart read(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input Stream is null");
        }
        Chart chart = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            ChartSAX chartSAX = new ChartSAX();
            sAXParser.parse(inputStream, (DefaultHandler)chartSAX);
            chart = (Chart)chartSAX.getObject();
            chart.loaded();
        }
        catch (Exception exception) {
            m_Log.error((Object)("reading chart file object: " + exception.toString()), (Throwable)exception);
        }
        return chart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Chart read(RMLFileObject rMLFileObject) throws IOException {
        if (rMLFileObject == null) {
            throw new IOException("Chart FileObject not found.");
        }
        Chart chart = null;
        try (InputStream inputStream = null;){
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            ChartSAX chartSAX = new ChartSAX();
            inputStream = rMLFileObject.getInputStream();
            sAXParser.parse(inputStream, (DefaultHandler)chartSAX);
            chart = (Chart)chartSAX.getObject();
            chart.setFileObject(rMLFileObject);
            chart.loaded();
        }
        return chart;
    }
}

