/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.windrose;

import com.elixirtech.chart2.windrose.BeaufortScale;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.xy.AbstractXYDataset;

public class WindRoseDataset
extends AbstractXYDataset {
    private final List<Datum> m_Data = new ArrayList<Datum>();
    private final int m_CalmCount;
    private final int m_TotalCount;
    private final int m_MaxBucket;

    public WindRoseDataset(List<Datum> list) {
        int n = 0;
        int n2 = 0;
        for (Datum datum : list) {
            if (datum.isCalm()) {
                ++n;
                continue;
            }
            n2 = Math.max(n2, datum.bucket);
            this.m_Data.add(datum);
        }
        this.m_CalmCount = n;
        this.m_TotalCount = list.size();
        this.m_MaxBucket = n2;
    }

    public int getCalmCount() {
        return this.m_CalmCount;
    }

    public int getTotalCount() {
        return this.m_TotalCount;
    }

    public int getMaxBucket() {
        return this.m_MaxBucket;
    }

    public int getSeriesCount() {
        return 1;
    }

    public Comparable<?> getSeriesKey(int n) {
        return "Series 1";
    }

    public int getItemCount(int n) {
        return this.m_Data.size();
    }

    public Datum getDatum(int n) {
        return this.m_Data.get(n);
    }

    public List<Datum> getData(int n) {
        ArrayList<Datum> arrayList = new ArrayList<Datum>();
        for (Datum datum : this.m_Data) {
            if (datum.direction != n) continue;
            arrayList.add(datum);
        }
        return arrayList;
    }

    public Number getX(int n, int n2) {
        return this.m_Data.get((int)n2).direction;
    }

    public Number getY(int n, int n2) {
        return this.m_Data.get((int)n2).velocity;
    }

    public void verify() {
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            int n2 = this.getData(i).size();
            System.out.println(i + ": " + n2);
            n += n2;
        }
        if (n != this.m_Data.size()) {
            throw new RuntimeException("Oops");
        }
    }

    public static class Datum {
        public final double velocity;
        public final int direction;
        public final int bucket;

        public Datum(BeaufortScale beaufortScale, double d, int n) {
            this.velocity = d;
            this.direction = (int)(((double)n - 11.25) / 22.5);
            this.bucket = beaufortScale.getBucket(this.velocity);
            assert (this.direction < 16);
        }

        public boolean isCalm() {
            return this.bucket == 0;
        }
    }
}

