/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.windrose;

import com.elixirtech.chart2.windrose.WindRoseAxis;
import com.elixirtech.chart2.windrose.WindRoseDataset;
import com.elixirtech.chart2.windrose.WindRoseItemRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.PolarItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.text.TextUtilities;

public class WindRosePlot
extends PolarPlot {
    public static final double MIN_RADIUS = 0.25;
    private static final String[] DEFAULT_LEGEND_LABELS = new String[]{"0-0.2", "0.3-1.5", "1.6-3.3", "3.4-5.4", "5.5-7.9", "8.0-10.7", "10.8-13.8", "13.9-17.1", "17.2-20.7", "20.8-24.4", "24.5-28.4", "28.5-32.6", "32.7-40.8"};
    private WindRoseDataset m_Dataset;
    private Font m_CenterLabelFont = new Font("SansSerif", 0, 12);
    private String[] m_LegendLabels = DEFAULT_LEGEND_LABELS;

    public WindRosePlot(WindRoseDataset windRoseDataset, WindRoseAxis windRoseAxis) {
        super((XYDataset)windRoseDataset, (ValueAxis)windRoseAxis, (PolarItemRenderer)new WindRoseItemRenderer());
        this.m_Dataset = windRoseDataset;
    }

    protected AxisState drawAxis(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = rectangle2D2.getMinX();
        double d2 = rectangle2D2.getMaxX();
        double d3 = rectangle2D2.getMinY();
        double d4 = rectangle2D2.getMaxY();
        d += (d2 - d) * 0.25;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
        return super.drawAxis(graphics2D, rectangle2D, (Rectangle2D)double_);
    }

    protected void drawCornerTextItems(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        super.drawCornerTextItems(graphics2D, rectangle2D);
        double d = rectangle2D.getCenterX();
        double d2 = rectangle2D.getCenterY();
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.m_CenterLabelFont);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        String string = "CALM";
        Rectangle2D rectangle2D2 = TextUtilities.getTextBounds((String)string, (Graphics2D)graphics2D, (FontMetrics)fontMetrics);
        graphics2D.drawString(string, (int)(d - rectangle2D2.getWidth() / 2.0), (int)(d2 - (double)(fontMetrics.getAscent() / 2)));
        d2 += rectangle2D2.getHeight();
        double d3 = this.m_Dataset.getCalmCount();
        double d4 = this.m_Dataset.getTotalCount();
        double d5 = d3 / d4;
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(1);
        String string2 = numberFormat.format(d5);
        Rectangle2D rectangle2D3 = TextUtilities.getTextBounds((String)string2, (Graphics2D)graphics2D, (FontMetrics)fontMetrics);
        graphics2D.drawString(string2, (int)(d - rectangle2D3.getWidth() / 2.0), (int)(d2 - (double)(fontMetrics.getAscent() / 2)));
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        int n = this.m_Dataset.getMaxBucket();
        Rectangle2D.Double double_ = new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0);
        for (int i = 0; i <= n; ++i) {
            String string = this.getLegendLabel(i);
            LegendItem legendItem = new LegendItem(string, null, null, null, (Shape)double_, (Paint)WindRoseItemRenderer.getColor(i), WindRoseItemRenderer.SOLID, (Paint)Color.blue);
            legendItemCollection.add(legendItem);
        }
        return legendItemCollection;
    }

    public void setCenterLabelFont(Font font) {
        this.m_CenterLabelFont = font;
    }

    public Font setCenterLabelFont() {
        return this.m_CenterLabelFont;
    }

    public void setLegendLabels(String[] stringArray) {
        this.m_LegendLabels = stringArray;
    }

    public String[] getLegendLabels() {
        return this.m_LegendLabels;
    }

    public String getLegendLabel(int n) {
        if (this.m_LegendLabels != null && n < this.m_LegendLabels.length) {
            return this.m_LegendLabels[n];
        }
        return String.valueOf(n);
    }
}

