/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data.transform;

import com.elixirtech.arch.XMLUtil$;
import com.elixirtech.arch.param.Template;
import com.elixirtech.arch.param.Template$;
import com.elixirtech.data.TransformBuilder;
import com.elixirtech.data.transform.Stemmer;
import com.elixirtech.data.transform.StringTransform;
import java.io.Serializable;
import org.apache.commons.codec.StringEncoder;
import scala.Char$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.xml.Node;

public final class StringTransform$
implements Function1,
TransformBuilder,
Serializable {
    private static final String TypeName;
    private static final boolean DoStem;
    private static final int MinPhoneticWordLength;
    public static final StringTransform$ MODULE$;

    private StringTransform$() {
    }

    static {
        MODULE$ = new StringTransform$();
        TypeName = "string";
        DoStem = true;
        MinPhoneticWordLength = 3;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StringTransform$.class);
    }

    public String TypeName() {
        return TypeName;
    }

    public boolean DoStem() {
        return DoStem;
    }

    public int MinPhoneticWordLength() {
        return MinPhoneticWordLength;
    }

    public StringTransform apply(Node xml) {
        String field = XMLUtil$.MODULE$.textOrFail(xml, "@field");
        String op = XMLUtil$.MODULE$.textOrFail(xml, "@op");
        Option param1 = XMLUtil$.MODULE$.text(xml, "@param1").map((Function1 & Serializable)_$1 -> Template$.MODULE$.apply(_$1));
        Option param2 = XMLUtil$.MODULE$.text(xml, "@param2").map((Function1 & Serializable)_$2 -> Template$.MODULE$.apply(_$2));
        Option<String> newColumn = XMLUtil$.MODULE$.text(xml, "@newColumn");
        return new StringTransform(field, op, (Option<Template>)param1, (Option<Template>)param2, newColumn);
    }

    public String capitalize(String s) {
        String string = s;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return s;
        }
        int strLen = s.length();
        scala.collection.mutable.StringBuilder buffer = new scala.collection.mutable.StringBuilder(strLen);
        BooleanRef capitalizeNext = BooleanRef.create((boolean)true);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), strLen).foreach((Function1 & Serializable)i -> this.capitalize$$anonfun$1(s, buffer, capitalizeNext, BoxesRunTime.unboxToInt((Object)i)));
        return buffer.toString();
    }

    public String ltrim(String s) {
        int i;
        String string = s;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return s;
        }
        int len = s.length();
        for (i = 0; i < len && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        return s.substring(i);
    }

    public String rtrim(String s) {
        int len;
        int i;
        String string = s;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return s;
        }
        for (i = len = s.length(); i > 0 && Character.isWhitespace(s.charAt(i - 1)); --i) {
        }
        return s.substring(0, i);
    }

    public String lpad(String s, String ch, int len) {
        Predef$.MODULE$.require(ch.length() > 0);
        if (s.length() >= len) {
            return s;
        }
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder(len);
        if (s != null) {
            sb.append(s);
        }
        while (sb.size() < len) {
            sb.insert(0, ch);
        }
        return sb.toString();
    }

    public String rpad(String s, String ch, int len) {
        Predef$.MODULE$.require(ch.length() > 0);
        if (s.length() >= len) {
            return s;
        }
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder(len);
        if (s != null) {
            sb.append(s);
        }
        while (sb.size() < len) {
            sb.append(ch);
        }
        return sb.toString();
    }

    public String hiraganaToKatakana(String s) {
        String string = s;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            StringBuilder stringBuilder = ch >= '\u3040' && ch <= '\u3096' ? sb.appendCodePoint(ch + 96) : sb.appendCodePoint(Char$.MODULE$.char2int(ch));
        }
        return sb.toString();
    }

    public String katakanaToHiragana(String s) {
        String string = s;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            StringBuilder stringBuilder = ch >= '\u30a0' && ch <= '\u30f6' ? sb.appendCodePoint(ch - 96) : sb.appendCodePoint(Char$.MODULE$.char2int(ch));
        }
        return sb.toString();
    }

    public String zenkakuToAscii(String s) {
        String string = s;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            StringBuilder stringBuilder = ch >= '\uff01' && ch <= '\uff5e' ? sb.appendCodePoint(ch - 65248) : sb.appendCodePoint(Char$.MODULE$.char2int(ch));
        }
        return sb.toString();
    }

    public String asciiToZenkaku(String s) {
        String string = s;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            StringBuilder stringBuilder = ch >= '!' && ch <= '~' ? sb.appendCodePoint(ch + 65248) : sb.appendCodePoint(Char$.MODULE$.char2int(ch));
        }
        return sb.toString();
    }

    public String stem(String s) {
        if (this.DoStem()) {
            Stemmer stemmer = new Stemmer();
            stemmer.add(s.toCharArray(), s.length());
            stemmer.stem();
            return stemmer.toString();
        }
        return s;
    }

    public String phoneticEncoder(StringEncoder enc, String s2) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])s2.split(" "));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$3 -> _$3.trim(), ClassTag$.MODULE$.apply(String.class)));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object2, (Function1 & Serializable)_$4 -> _$4.length() >= this.MinPhoneticWordLength()));
        Object[] words = (String[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)s -> this.stem((String)s), ClassTag$.MODULE$.apply(String.class));
        Object object4 = Predef$.MODULE$.refArrayOps(words);
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object4, (Function1 & Serializable)x$0 -> enc.encode(x$0), ClassTag$.MODULE$.apply(String.class))).mkString(" ");
    }

    public Set<String> phoneticEncoderSet(StringEncoder enc, String s2) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])s2.split(" "));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$5 -> _$5.trim(), ClassTag$.MODULE$.apply(String.class)));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object2, (Function1 & Serializable)_$6 -> _$6.length() >= this.MinPhoneticWordLength()));
        Object[] words = (String[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)s -> this.stem((String)s), ClassTag$.MODULE$.apply(String.class));
        Object object4 = Predef$.MODULE$.refArrayOps(words);
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object4, (Function1 & Serializable)x$0 -> enc.encode(x$0), ClassTag$.MODULE$.apply(String.class))).toSet();
    }

    private final /* synthetic */ Object capitalize$$anonfun$1(String s$13, scala.collection.mutable.StringBuilder buffer$1, BooleanRef capitalizeNext$1, int i) {
        char ch = s$13.charAt(i);
        if (Character.isWhitespace(ch)) {
            boolean bl;
            buffer$1.append(ch);
            capitalizeNext$1.elem = bl = true;
            return BoxedUnit.UNIT;
        }
        if (capitalizeNext$1.elem) {
            boolean bl;
            buffer$1.append(Character.toTitleCase(ch));
            capitalizeNext$1.elem = bl = false;
            return BoxedUnit.UNIT;
        }
        return buffer$1.append(ch);
    }
}

