/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data.transform.cluster;

import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.data.transform.cluster.KMeans$;
import com.elixirtech.data.transform.cluster.KMeans$Cluster$;
import com.elixirtech.data.transform.cluster.KMeans$IdxArray$;
import com.elixirtech.data.transform.cluster.KMeans$Result$;
import com.elixirtech.data.transform.cluster.KMeans$Runner$;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class KMeans {
    public static LoggingInterface log() {
        return KMeans$.MODULE$.log();
    }

    public static <T> Result<T> repeatRun(IndexedSeq<T> indexedSeq, Calc<T> calc, int n, int n2) {
        return KMeans$.MODULE$.repeatRun(indexedSeq, calc, n, n2);
    }

    public static <T> Result<T> run(IndexedSeq<T> indexedSeq, Calc<T> calc, int n) {
        return KMeans$.MODULE$.run(indexedSeq, calc, n);
    }

    public static class ArrayCalc
    implements Calc<double[]> {
        private final int len;

        public ArrayCalc(int len) {
            this.len = len;
        }

        @Override
        public double distance(double[] t1, double[] t2) {
            Predef$.MODULE$.require(t1.length == this.len, () -> this.distance$$anonfun$1(t1));
            Predef$.MODULE$.require(t2.length == this.len, () -> this.distance$$anonfun$2(t2));
            Object object = Predef$.MODULE$.doubleArrayOps(t1);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(object, (IterableOnce)Predef$.MODULE$.wrapDoubleArray(t2)));
            return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    double a = tuple2._1$mcD$sp();
                    double b = tuple2._2$mcD$sp();
                    return (a - b) * (a - b);
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Double.TYPE))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        }

        @Override
        public double[] center(IndexedSeq<double[]> ts) {
            double[] result = (double[])Array$.MODULE$.fill(this.len, this::$anonfun$1, ClassTag$.MODULE$.apply(Double.TYPE));
            ts.foreach((Function1)(JProcedure1 & Serializable)t -> {
                for (int i = 0; i < this.len; ++i) {
                    int n = i;
                    result$1[n] = result[n] + t[i];
                }
            });
            Object object = Predef$.MODULE$.doubleArrayOps(result);
            return (double[])ArrayOps$.MODULE$.map$extension(object, (Function1)(JFunction1.mcDD.sp & Serializable)_$1 -> _$1 / (double)ts.length(), ClassTag$.MODULE$.apply(Double.TYPE));
        }

        private final Object distance$$anonfun$1(double[] t1$1) {
            return "t1.length was " + t1$1.length + " expected " + this.len;
        }

        private final Object distance$$anonfun$2(double[] t2$1) {
            return "t2.length was " + t2$1.length + " expected " + this.len;
        }

        private final double $anonfun$1() {
            return 0.0;
        }
    }

    public static interface Calc<T> {
        public double distance(T var1, T var2);

        public T center(IndexedSeq<T> var1);
    }

    public static class Cluster<T>
    implements Product,
    Serializable {
        private final double dispersion;
        private final Object centroid;
        private final IndexedSeq members;

        public static <T> Cluster<T> apply(double d, T t, IndexedSeq<T> indexedSeq) {
            return KMeans$Cluster$.MODULE$.apply(d, t, indexedSeq);
        }

        public static Cluster<?> fromProduct(Product product) {
            return KMeans$Cluster$.MODULE$.fromProduct(product);
        }

        public static <T> Cluster<T> unapply(Cluster<T> cluster) {
            return KMeans$Cluster$.MODULE$.unapply(cluster);
        }

        public Cluster(double dispersion, T centroid, IndexedSeq<T> members) {
            this.dispersion = dispersion;
            this.centroid = centroid;
            this.members = members;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.dispersion()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.centroid()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.members()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Cluster)) return false;
            Cluster cluster = (Cluster)object;
            if (this.dispersion() != cluster.dispersion()) return false;
            if (!BoxesRunTime.equals(this.centroid(), cluster.centroid())) return false;
            IndexedSeq<T> indexedSeq = this.members();
            IndexedSeq<T> indexedSeq2 = cluster.members();
            if (indexedSeq == null) {
                if (indexedSeq2 != null) {
                    return false;
                }
            } else if (!indexedSeq.equals(indexedSeq2)) return false;
            if (!cluster.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Cluster;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Cluster";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "dispersion";
                }
                case 1: {
                    return "centroid";
                }
                case 2: {
                    return "members";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double dispersion() {
            return this.dispersion;
        }

        public T centroid() {
            return (T)this.centroid;
        }

        public IndexedSeq<T> members() {
            return this.members;
        }

        public String toString() {
            return "Cluster(" + this.dispersion() + ", " + this.centroid() + ")\n" + ((IterableOnceOps)this.members().map((Function1 & Serializable)_$3 -> "  " + _$3.toString())).mkString("\n") + "\n";
        }

        public <T> Cluster<T> copy(double dispersion, T centroid, IndexedSeq<T> members) {
            return new Cluster<T>(dispersion, centroid, members);
        }

        public double copy$default$1() {
            return this.dispersion();
        }

        public <T> T copy$default$2() {
            return this.centroid();
        }

        public <T> IndexedSeq<T> copy$default$3() {
            return this.members();
        }

        public double _1() {
            return this.dispersion();
        }

        public T _2() {
            return this.centroid();
        }

        public IndexedSeq<T> _3() {
            return this.members();
        }
    }

    public static class IdxArray
    implements Product,
    Serializable {
        private final int idx;
        private final double[] data;

        public static IdxArray apply(int n, double[] dArray) {
            return KMeans$IdxArray$.MODULE$.apply(n, dArray);
        }

        public static IdxArray fromProduct(Product product) {
            return KMeans$IdxArray$.MODULE$.fromProduct(product);
        }

        public static IdxArray unapply(IdxArray idxArray) {
            return KMeans$IdxArray$.MODULE$.unapply(idxArray);
        }

        public IdxArray(int idx, double[] data) {
            this.idx = idx;
            this.data = data;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.idx());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.data()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IdxArray)) return false;
            IdxArray idxArray = (IdxArray)object;
            if (this.idx() != idxArray.idx()) return false;
            if (this.data() != idxArray.data()) return false;
            if (!idxArray.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof IdxArray;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "IdxArray";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "idx";
            }
            if (1 == n2) {
                return "data";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int idx() {
            return this.idx;
        }

        public double[] data() {
            return this.data;
        }

        public IdxArray copy(int idx, double[] data) {
            return new IdxArray(idx, data);
        }

        public int copy$default$1() {
            return this.idx();
        }

        public double[] copy$default$2() {
            return this.data();
        }

        public int _1() {
            return this.idx();
        }

        public double[] _2() {
            return this.data();
        }
    }

    public static class IdxArrayCalc
    implements Calc<IdxArray> {
        private final int len;

        public IdxArrayCalc(int len) {
            this.len = len;
        }

        @Override
        public double distance(IdxArray t1, IdxArray t2) {
            Predef$.MODULE$.require(t1.data().length == this.len, () -> this.distance$$anonfun$4(t1));
            Predef$.MODULE$.require(t2.data().length == this.len, () -> this.distance$$anonfun$5(t2));
            Object object = Predef$.MODULE$.doubleArrayOps(t1.data());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(object, (IterableOnce)Predef$.MODULE$.wrapDoubleArray(t2.data())));
            return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    double a = tuple2._1$mcD$sp();
                    double b = tuple2._2$mcD$sp();
                    return (a - b) * (a - b);
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Double.TYPE))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        }

        @Override
        public IdxArray center(IndexedSeq<IdxArray> ts) {
            double[] result = (double[])Array$.MODULE$.fill(this.len, this::$anonfun$2, ClassTag$.MODULE$.apply(Double.TYPE));
            ts.foreach((Function1)(JProcedure1 & Serializable)t -> {
                for (int i = 0; i < this.len; ++i) {
                    int n = i;
                    result$2[n] = result[n] + t.data()[i];
                }
            });
            Object object = Predef$.MODULE$.doubleArrayOps(result);
            return KMeans$IdxArray$.MODULE$.apply(-1, (double[])ArrayOps$.MODULE$.map$extension(object, (Function1)(JFunction1.mcDD.sp & Serializable)_$2 -> _$2 / (double)ts.length(), ClassTag$.MODULE$.apply(Double.TYPE)));
        }

        private final Object distance$$anonfun$4(IdxArray t1$2) {
            return "t1.length was " + t1$2.data().length + " expected " + this.len;
        }

        private final Object distance$$anonfun$5(IdxArray t2$2) {
            return "t2.length was " + t2$2.data().length + " expected " + this.len;
        }

        private final double $anonfun$2() {
            return 0.0;
        }
    }

    public static class Result<T>
    implements Product,
    Serializable {
        private final double dispersion;
        private final IndexedSeq clusters;
        private final int iterationCount;

        public static <T> Result<T> apply(double d, IndexedSeq<Cluster<T>> indexedSeq, int n) {
            return KMeans$Result$.MODULE$.apply(d, indexedSeq, n);
        }

        public static Result<?> fromProduct(Product product) {
            return KMeans$Result$.MODULE$.fromProduct(product);
        }

        public static <T> Result<T> unapply(Result<T> result) {
            return KMeans$Result$.MODULE$.unapply(result);
        }

        public Result(double dispersion, IndexedSeq<Cluster<T>> clusters, int iterationCount) {
            this.dispersion = dispersion;
            this.clusters = clusters;
            this.iterationCount = iterationCount;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.dispersion()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.clusters()));
            n = Statics.mix((int)n, (int)this.iterationCount());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Result)) return false;
            Result result = (Result)object;
            if (this.dispersion() != result.dispersion()) return false;
            if (this.iterationCount() != result.iterationCount()) return false;
            IndexedSeq<Cluster<T>> indexedSeq = this.clusters();
            IndexedSeq<Cluster<T>> indexedSeq2 = result.clusters();
            if (indexedSeq == null) {
                if (indexedSeq2 != null) {
                    return false;
                }
            } else if (!indexedSeq.equals(indexedSeq2)) return false;
            if (!result.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Result;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Result";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "dispersion";
                }
                case 1: {
                    return "clusters";
                }
                case 2: {
                    return "iterationCount";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double dispersion() {
            return this.dispersion;
        }

        public IndexedSeq<Cluster<T>> clusters() {
            return this.clusters;
        }

        public int iterationCount() {
            return this.iterationCount;
        }

        public <T> Result<T> copy(double dispersion, IndexedSeq<Cluster<T>> clusters, int iterationCount) {
            return new Result<T>(dispersion, clusters, iterationCount);
        }

        public double copy$default$1() {
            return this.dispersion();
        }

        public <T> IndexedSeq<Cluster<T>> copy$default$2() {
            return this.clusters();
        }

        public int copy$default$3() {
            return this.iterationCount();
        }

        public double _1() {
            return this.dispersion();
        }

        public IndexedSeq<Cluster<T>> _2() {
            return this.clusters();
        }

        public int _3() {
            return this.iterationCount();
        }
    }

    public static class Runner<T> {
        private final IndexedSeq<T> points;
        private final Calc<T> calc;
        private final double minChangeInDispersion;
        private final int maxIterations;
        private final Random random;

        public static <T> boolean $lessinit$greater$default$3() {
            return KMeans$Runner$.MODULE$.$lessinit$greater$default$3();
        }

        public static <T> double $lessinit$greater$default$4() {
            return KMeans$Runner$.MODULE$.$lessinit$greater$default$4();
        }

        public static <T> int $lessinit$greater$default$5() {
            return KMeans$Runner$.MODULE$.$lessinit$greater$default$5();
        }

        public Runner(IndexedSeq<T> points, Calc<T> calc, boolean fixedSeedForRandom, double minChangeInDispersion, int maxIterations) {
            this.points = points;
            this.calc = calc;
            this.minChangeInDispersion = minChangeInDispersion;
            this.maxIterations = maxIterations;
            this.random = fixedSeedForRandom ? new Random(13) : new Random(System.currentTimeMillis());
        }

        public Result<T> run(int k) {
            IndexedSeq<T> starting = this.chooseRandomCentroids(k);
            Result<T> result = this.buildResult(starting, 0);
            double lastDispersion = result.dispersion();
            double dispersionChange = Double.POSITIVE_INFINITY;
            while (result.iterationCount() < this.maxIterations && dispersionChange > this.minChangeInDispersion) {
                IndexedSeq<T> centroids = this.center(result.clusters());
                result = this.buildResult(centroids, result.iterationCount() + 1);
                dispersionChange = package$.MODULE$.abs(lastDispersion - result.dispersion());
                lastDispersion = result.dispersion();
            }
            return result;
        }

        private Result<T> buildResult(IndexedSeq<T> centroids, int iterationCount) {
            IndexedSeq<Cluster<T>> clusters = this.classify(centroids);
            double dispersion = this.computeDispersion(clusters);
            return KMeans$Result$.MODULE$.apply(dispersion, clusters, iterationCount);
        }

        private IndexedSeq<T> chooseRandomCentroids(int k) {
            return (IndexedSeq)((IndexedSeqOps)this.random.shuffle(this.points, BuildFrom$.MODULE$.buildFromIterableOps())).take(k);
        }

        private IndexedSeq<Cluster<T>> classify(IndexedSeq<T> centroids) {
            ArrayBuffer[] members = (ArrayBuffer[])Array$.MODULE$.fill(centroids.length(), this::$anonfun$3, ClassTag$.MODULE$.apply(ArrayBuffer.class));
            double[] dispersions = (double[])Array$.MODULE$.fill(centroids.length(), this::$anonfun$4, ClassTag$.MODULE$.apply(Double.TYPE));
            this.points.foreach((Function1)(JProcedure1 & Serializable)pt -> {
                IndexedSeq distances = (IndexedSeq)centroids.map((Function1 & Serializable)c -> this.calc.distance(c, pt));
                Tuple2 tuple2 = (Tuple2)((IterableOnceOps)distances.zipWithIndex()).min(Ordering$.MODULE$.Tuple2((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                double shortestDistance = BoxesRunTime.unboxToDouble((Object)tuple2._1());
                int closestCentroid = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(shortestDistance, closestCentroid);
                double shortestDistance2 = sp2._1$mcD$sp();
                int closestCentroid2 = sp2._2$mcI$sp();
                members[closestCentroid2].$plus$eq(pt);
                dispersions$1[closestCentroid2] = dispersions[closestCentroid2] + shortestDistance2 * shortestDistance2;
            });
            return (IndexedSeq)((IndexedSeqOps)centroids.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object c = tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return KMeans$Cluster$.MODULE$.apply(dispersions[i], c, members[i].toIndexedSeq());
                }
                throw new MatchError((Object)tuple2);
            });
        }

        private IndexedSeq<T> center(IndexedSeq<Cluster<T>> clusters) {
            return (IndexedSeq)clusters.map((Function1 & Serializable)c -> this.calc.center(c.members()));
        }

        private double computeDispersion(IndexedSeq<Cluster<T>> clusters) {
            return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)clusters.map((Function1 & Serializable)_$6 -> _$6.dispersion())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        }

        private final ArrayBuffer $anonfun$3() {
            return new ArrayBuffer();
        }

        private final double $anonfun$4() {
            return 0.0;
        }
    }
}

