/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ParamMatcher;
import com.elixirtech.data2.Parameter;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArgumentMapJ {
    public static final String LEGACY = "legacy-param";
    private Map<String, Object> m_Arguments = new HashMap<String, Object>();
    private Map<String, Parameter> m_Parameters = new TreeMap<String, Parameter>();
    private static final String NAME_REGEXP = "([^<]+)<([^>]+)>(.*)";
    public static final Pattern NAME_PATTERN = Pattern.compile("([^<]+)<([^>]+)>(.*)");
    private static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    public static Parameter buildParameter(String string, String string2, String string3) {
        if (string.indexOf("<") >= 0) {
            String[] stringArray = StringUtil.EMPTY_ARRAY;
            Matcher matcher = NAME_PATTERN.matcher(string);
            if (matcher.find()) {
                String string4 = matcher.group(1);
                String string5 = matcher.group(2);
                stringArray = string5.split(",");
                return new Parameter(string4, string2, string3, stringArray);
            }
        }
        return new Parameter(string, string2, string3);
    }

    public static String getDefaultString(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        ParamMatcher paramMatcher = new ParamMatcher(string);
        while (paramMatcher.find()) {
            String string2 = paramMatcher.getDefault();
            stringBuilder.append(string.substring(n, paramMatcher.getStart()));
            if (string2 != null) {
                stringBuilder.append(String.valueOf(string2));
            }
            n = paramMatcher.getEnd();
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    public void resetParameters() {
        this.m_Parameters.clear();
    }

    public static List<Parameter> extractListofParameters(String string) {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        if (string != null) {
            ParamMatcher paramMatcher = new ParamMatcher(string);
            while (paramMatcher.find()) {
                String string2 = paramMatcher.getName();
                if (string2.startsWith("=")) continue;
                String string3 = paramMatcher.getType();
                String string4 = paramMatcher.getDefault();
                if (string3 == null) {
                    string3 = "";
                }
                if (string4 == null) {
                    string4 = "";
                }
                arrayList.add(ArgumentMapJ.buildParameter(string2, string3, string4));
            }
        }
        return arrayList;
    }

    public boolean extractParameters(String string) {
        boolean bl = false;
        if (string != null) {
            ParamMatcher paramMatcher = new ParamMatcher(string);
            while (paramMatcher.find()) {
                String string2 = paramMatcher.getName();
                if (string2.startsWith("=")) continue;
                String string3 = paramMatcher.getType();
                String string4 = paramMatcher.getDefault();
                if (string3 == null) {
                    string3 = "";
                }
                if (string4 == null) {
                    string4 = "";
                }
                this.m_Parameters.put(string2, ArgumentMapJ.buildParameter(string2, string3, string4));
                bl = true;
            }
        }
        return bl;
    }

    public void addLegacyParameter(String string) {
        this.m_Parameters.put(string, new Parameter(string, LEGACY, ""));
    }

    public void removeParameter(String string) {
        this.m_Parameters.remove(string);
    }

    public void addParameters(List<Parameter> list) {
        for (Parameter parameter : list) {
            this.m_Parameters.put(parameter.getName(), parameter);
        }
    }

    public void addParameter(Parameter parameter) {
        this.m_Parameters.put(parameter.getName(), parameter);
    }

    public boolean contains(String string) {
        return this.m_Parameters.containsKey(string);
    }

    public boolean isLegacy(String string) {
        Parameter parameter = this.m_Parameters.get(string);
        return parameter != null && LEGACY.equals(parameter.getType());
    }

    public List<Parameter> getParameters() {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        arrayList.addAll(this.m_Parameters.values());
        return arrayList;
    }

    public String getString(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("${") < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        ParamMatcher paramMatcher = new ParamMatcher(string);
        while (paramMatcher.find()) {
            String string2 = ArgumentMapJ.ignoreDependencies(paramMatcher.getName());
            String string3 = paramMatcher.getDefault();
            Object object = this.m_Arguments.get(string2);
            if (object == null) {
                object = string3;
            }
            stringBuilder.append(string.substring(n, paramMatcher.getStart()));
            if (object != null) {
                stringBuilder.append(String.valueOf(object));
            }
            n = paramMatcher.getEnd();
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    public void setArgument(String string, Object object) {
        if (!this.m_Parameters.containsKey(string)) {
            throw new IllegalArgumentException("Unknown parameter " + string);
        }
        if (object != null) {
            this.m_Arguments.put(string, object);
        } else if (string != null) {
            this.m_Arguments.remove(string);
        }
    }

    public Object getArgument(String string) {
        return this.m_Arguments.get(string);
    }

    public static String substitute(String string, ICallback iCallback) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("${") < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        ParamMatcher paramMatcher = new ParamMatcher(string);
        while (paramMatcher.find()) {
            String string2;
            String string3 = ArgumentMapJ.ignoreDependencies(paramMatcher.getName());
            if (string3.startsWith("=")) {
                stringBuilder.append(string.substring(n, paramMatcher.getStart()));
                string2 = iCallback.getValue(string3, "script");
                if (string2 == null) {
                    string2 = ArgumentMapJ.evaluate(string3.substring(1));
                }
                if (string2 != null) {
                    stringBuilder.append(String.valueOf(string2));
                }
                n = paramMatcher.getEnd();
                continue;
            }
            string2 = paramMatcher.getType();
            String string4 = paramMatcher.getDefault();
            String string5 = iCallback.getValue(string3, string2);
            if (string5 == null) {
                string5 = string4;
            }
            if (string5 == null) {
                string5 = System.getProperty(string3);
            }
            stringBuilder.append(string.substring(n, paramMatcher.getStart()));
            if (string5 != null) {
                stringBuilder.append(String.valueOf(string5));
            }
            n = paramMatcher.getEnd();
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String evaluate(String string) {
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        javaScriptEngine.pushScope();
        try {
            Object object = javaScriptEngine.evaluate("PushContext", string);
            if (object != null) {
                String string2 = String.valueOf(object);
                return string2;
            }
            String string3 = null;
            return string3;
        }
        catch (ScriptException scriptException) {
            m_JSLog.error((Object)("Script error in getValue(" + string + "): " + scriptException), (Throwable)scriptException);
            String string4 = null;
            return string4;
        }
        finally {
            javaScriptEngine.popScope();
        }
    }

    private static String ignoreDependencies(String string) {
        Matcher matcher;
        if (string.indexOf(60) >= 0 && (matcher = NAME_PATTERN.matcher(string)).find()) {
            return matcher.group(1);
        }
        return string;
    }

    public static interface ICallback {
        public String getValue(String var1, String var2);
    }

    public static class MapWrapper
    implements ICallback {
        private Map<String, String> m_Map;

        public MapWrapper(Map<String, String> map) {
            this.m_Map = map;
        }

        @Override
        public String getValue(String string, String string2) {
            return this.m_Map.get(string);
        }
    }

    public static class CallbackMap
    extends HashMap<String, String>
    implements ICallback {
        @Override
        public String getValue(String string, String string2) {
            return (String)this.get(string);
        }
    }
}

