/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.jdom.Element;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;

public class DataAttributes {
    private final List<DataAttribute> m_Attributes = new ArrayList<DataAttribute>();

    public DataAttributes() {
    }

    public DataAttributes(Element element) {
        for (Element element2 : element.getChildren("attribute", Data2Constants.NS_DATASOURCE)) {
            DataAttribute dataAttribute = DataAttribute.newDataAttribute(element2);
            if (dataAttribute == null) continue;
            this.m_Attributes.add(dataAttribute);
        }
        this.sort();
    }

    public Element getElement() {
        Element element = new Element("attributes", Data2Constants.NS_DATASOURCE);
        for (DataAttribute dataAttribute : this.m_Attributes) {
            element.addContent(dataAttribute.getElement());
        }
        return element;
    }

    public boolean isEmpty() {
        return this.m_Attributes.isEmpty();
    }

    public DataAttributes(List<DataAttribute> list) {
        this.m_Attributes.addAll(list);
        this.sort();
    }

    public DataAttributes(DataAttributes dataAttributes) {
        this.m_Attributes.addAll(dataAttributes.getAttributes());
    }

    public void addAttribute(DataAttribute dataAttribute) {
        this.m_Attributes.add(dataAttribute);
        this.sort();
    }

    public void removeAttribute(DataAttribute dataAttribute) {
        this.m_Attributes.remove(dataAttribute);
    }

    public <T extends DataAttribute> T getAttribute(Class<T> clazz) {
        for (DataAttribute dataAttribute : this.m_Attributes) {
            if (!dataAttribute.getClass().equals(clazz)) continue;
            return (T)((DataAttribute)clazz.cast(dataAttribute));
        }
        return null;
    }

    public List<DataAttribute> getAttributes() {
        return Collections.unmodifiableList(this.m_Attributes);
    }

    public String getRenderableName() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<DataAttribute> iterator = this.m_Attributes.iterator();
        while (iterator.hasNext()) {
            DataAttribute dataAttribute = iterator.next();
            stringBuilder.append(dataAttribute.getRenderableName());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.toString();
    }

    public Icon getRenderableIcon() {
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DataAttributes) {
            DataAttributes dataAttributes = (DataAttributes)object;
            if (this.m_Attributes.size() != dataAttributes.m_Attributes.size()) {
                return false;
            }
            List<DataAttribute> list = this.getAttributes();
            List<DataAttribute> list2 = dataAttributes.getAttributes();
            int n = list.size();
            if (n == list2.size()) {
                for (int i = 0; i < n; ++i) {
                    if (list.get(i).equals(list2.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = this.m_Attributes.size();
        for (DataAttribute dataAttribute : this.m_Attributes) {
            n ^= dataAttribute.hashCode();
        }
        return n;
    }

    public String toString() {
        return this.getRenderableName();
    }

    private void sort() {
        Collections.sort(this.m_Attributes);
    }
}

