/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.arch.ByteUtil;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.NullGroup;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.SchemaItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public final class DataSchema {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String SHORT_TIME_FORMAT = "HH:mm";
    public static final String DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String OLD_ER_DATE_FORMAT = "MM/dd/yy HH:mm:ss";
    public static final byte[] BINARY_MARKER = new byte[]{100, 115, 115, 99};
    protected final boolean m_IsCaseSensitive;
    protected final SchemaItem[] m_Items;
    protected DateFormat m_DateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    protected DateFormat m_TimeFormatter = new SimpleDateFormat("HH:mm:ss");
    protected DateFormat m_ShortTimeFormatter = new SimpleDateFormat("HH:mm");
    protected DateFormat m_TimestampFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected String m_DateFormat = "yyyy-MM-dd";
    protected String m_TimeFormat = "HH:mm:ss";
    protected String m_TimestampFormat = "yyyy-MM-dd HH:mm:ss";
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DataSchema.class);

    public DataSchema() {
        this(true, new SchemaItem[0]);
    }

    public DataSchema(boolean bl, String[] stringArray, DataType[] dataTypeArray) {
        if (stringArray.length != dataTypeArray.length) {
            throw new IllegalArgumentException("cols.length!=types.length");
        }
        this.m_IsCaseSensitive = bl;
        this.m_Items = new SchemaItem[stringArray.length];
        for (int i = 0; i < this.m_Items.length; ++i) {
            this.m_Items[i] = new SchemaItem(stringArray[i], dataTypeArray[i], new DataAttributes());
        }
    }

    public DataSchema(boolean bl, String[] stringArray, DataType[] dataTypeArray, DataAttributes[] dataAttributesArray) {
        if (stringArray.length != dataTypeArray.length) {
            throw new IllegalArgumentException("cols.length!=types.length");
        }
        if (stringArray.length != dataAttributesArray.length) {
            throw new IllegalArgumentException("cols.length!=attrs.length");
        }
        this.m_IsCaseSensitive = bl;
        this.m_Items = new SchemaItem[stringArray.length];
        for (int i = 0; i < this.m_Items.length; ++i) {
            DataAttributes dataAttributes = dataAttributesArray[i];
            if (dataAttributes == null) {
                dataAttributes = new DataAttributes();
            }
            this.m_Items[i] = new SchemaItem(stringArray[i], dataTypeArray[i], dataAttributes);
        }
    }

    public DataSchema(boolean bl, SchemaItem[] schemaItemArray) {
        this.m_IsCaseSensitive = bl;
        this.m_Items = new SchemaItem[schemaItemArray.length];
        System.arraycopy(schemaItemArray, 0, this.m_Items, 0, schemaItemArray.length);
    }

    public DataSchema(boolean bl, Collection<? extends SchemaItem> collection) {
        this.m_IsCaseSensitive = bl;
        this.m_Items = collection.toArray(new SchemaItem[collection.size()]);
    }

    public DataAttributes getAttributes(int n) {
        return this.m_Items[n].attrs;
    }

    public <T extends DataAttribute> T getAttribute(int n, Class<T> clazz) {
        return this.m_Items[n].attrs.getAttribute(clazz);
    }

    public void addAttribute(int n, DataAttribute dataAttribute) {
        this.m_Items[n].attrs.addAttribute(dataAttribute);
    }

    public int getAttributeIndex(String string) {
        for (int i = 0; i < this.m_Items.length; ++i) {
            for (DataAttribute dataAttribute : this.m_Items[i].attrs.getAttributes()) {
                if (!string.equals(dataAttribute.getName())) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean isCaseSensitive() {
        return this.m_IsCaseSensitive;
    }

    public String getDateFormat() {
        return this.m_DateFormat;
    }

    public String getTimeFormat() {
        return this.m_TimeFormat;
    }

    public String getTimestampFormat() {
        return this.m_TimestampFormat;
    }

    public void setDateFormat(String string) {
        this.m_DateFormat = string;
        this.m_DateFormatter = new SimpleDateFormat(this.m_DateFormat);
    }

    public void setTimeFormat(String string) {
        this.m_TimeFormat = string;
        this.m_TimeFormatter = new SimpleDateFormat(this.m_TimeFormat);
    }

    public void setTimestampFormat(String string) {
        this.m_TimestampFormat = string;
        this.m_TimestampFormatter = new SimpleDateFormat(this.m_TimestampFormat);
    }

    public List<SchemaItem> getColumns() {
        return Collections.unmodifiableList(Arrays.asList(this.m_Items));
    }

    public int getColumnCount() {
        return this.m_Items.length;
    }

    public SchemaItem getColumn(int n) {
        return this.m_Items[n];
    }

    public String getColumnName(int n) {
        return this.m_Items[n].name;
    }

    public DataType getColumnType(int n) {
        return this.m_Items[n].type;
    }

    public int getColumnIndex(String string) {
        if (string == null) {
            return -1;
        }
        if (this.m_IsCaseSensitive) {
            for (int i = 0; i < this.m_Items.length; ++i) {
                if (!string.equals(this.m_Items[i].name)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.m_Items.length; ++i) {
                if (!string.equalsIgnoreCase(this.m_Items[i].name)) continue;
                return i;
            }
        }
        return -1;
    }

    public Object convert(DataType dataType, Object object, DataType dataType2) {
        if (object == null) {
            return object;
        }
        switch (dataType.getTypeId()) {
            case 8: {
                return this.asLong(object);
            }
            case 18: {
                return this.asDecimal(object);
            }
            case 6: {
                return this.asDouble(object);
            }
            case 0: {
                return object;
            }
        }
        return this.parse(dataType2, this.format(dataType, object));
    }

    public Object parse(DataType dataType, String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            switch (dataType.getTypeId()) {
                case 2: {
                    return string;
                }
                case 8: {
                    return Double.valueOf(string.trim()).longValue();
                }
                case 18: {
                    return new BigDecimal(string.trim());
                }
                case 6: {
                    return Double.valueOf(string.trim());
                }
                case 3: {
                    return Boolean.valueOf(string.trim());
                }
                case 4: {
                    return this.parseDate(string.trim());
                }
                case 12: {
                    return this.parseTime(string.trim());
                }
                case 13: {
                    return this.parseTimestamp(string.trim());
                }
                case 17: {
                    return ByteUtil.decodeBase64(string.trim());
                }
                case 0: {
                    return string;
                }
            }
            throw new RuntimeException("Unknown DataType: " + dataType.getTypeName());
        }
        catch (Exception exception) {
            if (dataType.getTypeId() == 13) {
                m_Log.error((Object)("Can't parse " + string + " expecting format: " + this.m_DateFormat));
            }
            throw new RuntimeException("DataSchema.parse(" + dataType.getTypeName() + "," + string + ") Exception: " + exception, exception);
        }
    }

    public String format(DataType dataType, Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof NullGroup) {
            return "";
        }
        try {
            switch (dataType.getTypeId()) {
                case 2: {
                    return object.toString();
                }
                case 18: {
                    return ((BigDecimal)object).toPlainString();
                }
                case 6: {
                    Double d = (Double)object;
                    if (d.isInfinite()) {
                        return "Infinity";
                    }
                    if (d.isNaN()) {
                        return "NaN";
                    }
                    try {
                        return BigDecimal.valueOf((Double)object).toPlainString();
                    }
                    catch (NumberFormatException numberFormatException) {
                        m_Log.error((Object)("Can't parse " + object + "as Double"));
                        return object.toString();
                    }
                }
                case 17: {
                    if (object instanceof byte[]) {
                        return ByteUtil.encodeBase64((byte[])object);
                    }
                    return "";
                }
                case 4: {
                    return this.formatDate((Date)object);
                }
                case 12: {
                    return this.formatTime((Date)object);
                }
                case 13: {
                    return this.formatTimestamp((Date)object);
                }
            }
            return object.toString();
        }
        catch (ClassCastException classCastException) {
            m_Log.error((Object)("Attempt to cast a " + object.getClass().getSimpleName() + " to a " + dataType.getTypeName()));
            return "<Error>";
        }
    }

    public Object narrow(DataType dataType, Object object) {
        if (object == null) {
            return object;
        }
        switch (dataType.getTypeId()) {
            case 2: {
                return object.toString();
            }
            case 8: {
                return this.asLong(object);
            }
            case 6: {
                return this.asDouble(object);
            }
            case 18: {
                return this.asDecimal(object);
            }
            case 3: {
                return object;
            }
            case 4: {
                return object;
            }
            case 12: {
                return object;
            }
            case 13: {
                return object;
            }
            case 17: {
                return object;
            }
            case 0: {
                return object;
            }
        }
        throw new RuntimeException("Unknown DataType: " + dataType.getTypeName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DataSchema) {
            DataSchema dataSchema = (DataSchema)object;
            if (dataSchema.m_IsCaseSensitive != this.m_IsCaseSensitive) {
                return false;
            }
            if (dataSchema.m_Items.length != this.m_Items.length) {
                return false;
            }
            for (int i = 0; i < this.m_Items.length; ++i) {
                if (this.m_IsCaseSensitive && !dataSchema.m_Items[i].name.equals(this.m_Items[i].name)) {
                    return false;
                }
                if (!dataSchema.m_Items[i].name.equalsIgnoreCase(this.m_Items[i].name)) {
                    return false;
                }
                if (dataSchema.m_Items[i].type != this.m_Items[i].type) {
                    return false;
                }
                if (this.equal(dataSchema.m_Items[i].attrs, this.m_Items[i].attrs)) continue;
                return false;
            }
            if (!dataSchema.m_DateFormat.equals(this.m_DateFormat)) {
                return false;
            }
            if (!dataSchema.m_TimeFormat.equals(this.m_TimeFormat)) {
                return false;
            }
            return dataSchema.m_TimestampFormat.equals(this.m_TimestampFormat);
        }
        return false;
    }

    public String whatIsDifferent(Object object) {
        if (object == this) {
            return "Same object";
        }
        if (object instanceof DataSchema) {
            DataSchema dataSchema = (DataSchema)object;
            if (dataSchema.m_IsCaseSensitive != this.m_IsCaseSensitive) {
                return "Wrong case sensitivity";
            }
            if (dataSchema.m_Items.length != this.m_Items.length) {
                return "Different column length";
            }
            for (int i = 0; i < this.m_Items.length; ++i) {
                if (this.m_IsCaseSensitive && !dataSchema.m_Items[i].name.equals(this.m_Items[i].name)) {
                    return "different column name (sensitive)";
                }
                if (!dataSchema.m_Items[i].name.equalsIgnoreCase(this.m_Items[i].name)) {
                    return "different column name (insensitive)";
                }
                if (dataSchema.m_Items[i].type != this.m_Items[i].type) {
                    return "different types";
                }
                if (this.equal(dataSchema.m_Items[i].attrs, this.m_Items[i].attrs)) continue;
                return "different attributes";
            }
            if (!dataSchema.m_DateFormat.equals(this.m_DateFormat)) {
                return "different date format";
            }
            if (!dataSchema.m_TimeFormat.equals(this.m_TimeFormat)) {
                return "different time format";
            }
            if (!dataSchema.m_TimestampFormat.equals(this.m_TimestampFormat)) {
                return "different timestamp format";
            }
            return "Same contents";
        }
        return "Not a schema";
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(BINARY_MARKER);
        dataOutputStream.writeChar(this.m_IsCaseSensitive ? 84 : 70);
        dataOutputStream.writeUTF(this.m_DateFormat);
        dataOutputStream.writeUTF(this.m_TimeFormat);
        dataOutputStream.writeUTF(this.m_TimestampFormat);
        int n = this.getColumnCount();
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeUTF(this.getColumnName(i));
            dataOutputStream.writeInt(this.getColumnType(i).getTypeId());
            DataAttributes dataAttributes = this.m_Items[i].attrs;
            List<DataAttribute> list = dataAttributes.getAttributes();
            dataOutputStream.writeInt(list.size());
            for (DataAttribute dataAttribute : list) {
                dataOutputStream.writeUTF(dataAttribute.getMemento());
            }
        }
    }

    public static DataSchema read(DataInputStream dataInputStream) throws IOException {
        boolean bl;
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray);
        for (bl = false; bl < BINARY_MARKER.length; bl += 1) {
            if (byArray[bl] == BINARY_MARKER[bl]) continue;
            throw new IOException("Invalid schema header");
        }
        bl = 'T' == dataInputStream.readChar();
        SchemaBuilder schemaBuilder = new SchemaBuilder(bl, true);
        schemaBuilder.setDateFormat(dataInputStream.readUTF());
        schemaBuilder.setTimeFormat(dataInputStream.readUTF());
        schemaBuilder.setTimestampFormat(dataInputStream.readUTF());
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            DataType dataType = DataType.getInstance(dataInputStream.readInt());
            int n2 = dataInputStream.readInt();
            DataAttributes dataAttributes = new DataAttributes();
            for (int j = 0; j < n2; ++j) {
                String string2 = dataInputStream.readUTF();
                DataAttribute dataAttribute = DataAttribute.newDataAttribute(string2);
                if (dataAttribute == null) {
                    throw new IOException("Unknown data attribute: " + string2);
                }
                dataAttributes.addAttribute(dataAttribute);
            }
            schemaBuilder.add(string, dataType, dataAttributes);
        }
        return schemaBuilder.getSchema();
    }

    private boolean equal(DataAttributes dataAttributes, DataAttributes dataAttributes2) {
        if (dataAttributes == null || dataAttributes.isEmpty()) {
            return dataAttributes2 == null || dataAttributes2.isEmpty();
        }
        return dataAttributes.equals(dataAttributes2);
    }

    private Long asLong(Object object) {
        if (object instanceof Number) {
            if (object instanceof Long) {
                return (Long)object;
            }
            Number number = (Number)object;
            if (Double.isNaN(number.doubleValue())) {
                return null;
            }
            return number.longValue();
        }
        return null;
    }

    private Double asDouble(Object object) {
        if (object instanceof Number) {
            if (object instanceof Double) {
                return (Double)object;
            }
            Number number = (Number)object;
            double d = number.doubleValue();
            return d;
        }
        return null;
    }

    private BigDecimal asDecimal(Object object) {
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            double d = number.doubleValue();
            return new BigDecimal(d);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date parseDate(String string) throws ParseException {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        DateFormat dateFormat = this.m_DateFormatter;
        synchronized (dateFormat) {
            return this.m_DateFormatter.parse(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date parseTime(String string) throws ParseException {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        try {
            DateFormat dateFormat = this.m_TimeFormatter;
            synchronized (dateFormat) {
                return this.m_TimeFormatter.parse(string);
            }
        }
        catch (ParseException parseException) {
            return this.parseShortTime(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date parseShortTime(String string) throws ParseException {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        DateFormat dateFormat = this.m_ShortTimeFormatter;
        synchronized (dateFormat) {
            return this.m_ShortTimeFormatter.parse(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date parseTimestamp(String string) throws ParseException {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        try {
            DateFormat dateFormat = this.m_TimestampFormatter;
            synchronized (dateFormat) {
                return this.m_TimestampFormatter.parse(string.replace("T", " "));
            }
        }
        catch (ParseException parseException) {
            return this.parseDate(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String formatDate(Date date) {
        DateFormat dateFormat = this.m_DateFormatter;
        synchronized (dateFormat) {
            return this.m_DateFormatter.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String formatTime(Date date) {
        DateFormat dateFormat = this.m_TimeFormatter;
        synchronized (dateFormat) {
            return this.m_TimeFormatter.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String formatTimestamp(Date date) {
        DateFormat dateFormat = this.m_TimestampFormatter;
        synchronized (dateFormat) {
            return this.m_TimestampFormatter.format(date);
        }
    }
}

