/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.types.BooleanDataType;
import com.elixirtech.data2.types.ByteArrayDataType;
import com.elixirtech.data2.types.DateDataType;
import com.elixirtech.data2.types.DecimalDataType;
import com.elixirtech.data2.types.DoubleDataType;
import com.elixirtech.data2.types.LongDataType;
import com.elixirtech.data2.types.StringDataType;
import com.elixirtech.data2.types.TimeDataType;
import com.elixirtech.data2.types.TimestampDataType;
import com.elixirtech.data2.types.UnknownDataType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public abstract class DataType
implements Comparator<Object> {
    private static Map<String, DataType> m_DataTypes = new HashMap<String, DataType>();
    public static final int UNKNOWN_ID = 0;
    public static final int STRING_ID = 2;
    public static final int BOOLEAN_ID = 3;
    public static final int DATE_ID = 4;
    public static final int DOUBLE_ID = 6;
    public static final int LONG_ID = 8;
    public static final int TIME_ID = 12;
    public static final int TIMESTAMP_ID = 13;
    public static final int BYTE_ARRAY_ID = 17;
    public static final int DECIMAL_ID = 18;
    public static final DataType BOOLEAN = new BooleanDataType();
    public static final DataType BYTE_ARRAY = new ByteArrayDataType();
    public static final DataType DATE = new DateDataType();
    public static final DataType DECIMAL = new DecimalDataType();
    public static final DataType DOUBLE = new DoubleDataType();
    public static final DataType LONG = new LongDataType();
    public static final DataType STRING = new StringDataType();
    public static final DataType TIME = new TimeDataType();
    public static final DataType TIMESTAMP = new TimestampDataType();
    public static final DataType UNKNOWN = new UnknownDataType();
    public static final DataType[] TYPES = new DataType[]{BOOLEAN, BYTE_ARRAY, DATE, DECIMAL, DOUBLE, LONG, STRING, TIME, TIMESTAMP, UNKNOWN};
    public static final DataType[] TYPES_BY_ID = new DataType[]{UNKNOWN, LONG, STRING, BOOLEAN, DATE, DOUBLE, DOUBLE, BYTE_ARRAY, LONG, STRING, LONG, LONG, TIME, TIMESTAMP, STRING, BYTE_ARRAY, BYTE_ARRAY, BYTE_ARRAY, DECIMAL};

    public static DataType getInstance(int n) {
        return TYPES_BY_ID[n];
    }

    public static DataType getInstance(String string) {
        DataType dataType = m_DataTypes.get(string);
        if (dataType == null) {
            ElxLoggerJ.getLogger(DataType.class).error((Object)("Unknown data type: " + string));
            return UNKNOWN;
        }
        return dataType;
    }

    protected DataType() {
        m_DataTypes.put(this.getTypeName(), this);
    }

    public abstract int getTypeId();

    public abstract String getTypeName();

    public abstract boolean isNumeric();

    public abstract Object narrow(Object var1);

    @Override
    public abstract int compare(Object var1, Object var2);

    public abstract Object defaultValue();

    public abstract int writeLength(Object var1);

    public abstract void write(DataOutputStream var1, Object var2) throws IOException;

    public abstract Object read(DataInputStream var1) throws IOException;

    public String toString() {
        return this.getTypeName();
    }

    static {
        m_DataTypes.put("Object", BYTE_ARRAY);
        m_DataTypes.put("Blob", BYTE_ARRAY);
        m_DataTypes.put("Byte", LONG);
        m_DataTypes.put("Short", LONG);
        m_DataTypes.put("Integer", LONG);
        m_DataTypes.put("Float", DOUBLE);
        m_DataTypes.put("Character", STRING);
        m_DataTypes.put("Clob", STRING);
        m_DataTypes.put("XML", STRING);
    }
}

