/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;

public class RecordExtractor
implements DataListener {
    private final int m_Index;
    private int m_Count;
    private DataRecord m_Record;

    public static DataRecord getRecord(IDataSource iDataSource, int n) throws DataException {
        return RecordExtractor.getRecord(new DefaultPushContext(), iDataSource, n);
    }

    public static DataRecord getRecord(PushContext pushContext, IDataSource iDataSource, int n) throws DataException {
        RecordExtractor recordExtractor = new RecordExtractor(n);
        iDataSource.pushTo(pushContext, recordExtractor);
        return recordExtractor.getRecord();
    }

    public RecordExtractor(int n) {
        this.m_Index = n;
    }

    @Override
    public void startData(IDataSource iDataSource) {
        this.m_Count = 0;
    }

    @Override
    public void startGroup(DataGroup dataGroup) {
    }

    @Override
    public boolean processRecord(DataRecord dataRecord) {
        if (this.m_Count == this.m_Index) {
            ++this.m_Count;
            this.m_Record = dataRecord;
            return false;
        }
        ++this.m_Count;
        return true;
    }

    @Override
    public void endGroup(DataGroup dataGroup) {
    }

    @Override
    public void endData(IDataSource iDataSource) {
    }

    public DataRecord getRecord() {
        return this.m_Record;
    }
}

