/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.SchemaItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SchemaBuilder {
    protected final boolean m_IsCaseSensitive;
    protected final boolean m_AllowDuplicateNames;
    protected String m_DateFormat;
    protected String m_TimeFormat;
    protected String m_TimestampFormat;
    protected final List<SchemaItem> m_Items = new ArrayList<SchemaItem>();

    public SchemaBuilder(boolean bl, boolean bl2) {
        this.m_IsCaseSensitive = bl;
        this.m_AllowDuplicateNames = bl2;
        this.m_DateFormat = "yyyy-MM-dd";
        this.m_TimeFormat = "HH:mm:ss";
        this.m_TimestampFormat = "yyyy-MM-dd HH:mm:ss";
    }

    public SchemaBuilder(boolean bl) {
        this(bl, false);
    }

    public SchemaBuilder(DataSchema dataSchema) {
        this.m_IsCaseSensitive = dataSchema.isCaseSensitive();
        this.m_AllowDuplicateNames = false;
        this.m_DateFormat = dataSchema.getDateFormat();
        this.m_TimeFormat = dataSchema.getTimeFormat();
        this.m_TimestampFormat = dataSchema.getTimestampFormat();
        this.add(dataSchema);
    }

    public void add(DataSchema dataSchema) {
        int n = dataSchema.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.add(new SchemaItem(dataSchema.getColumnName(i), dataSchema.getColumnType(i), dataSchema.getAttributes(i)));
        }
    }

    public void setDateFormat(String string) {
        this.m_DateFormat = string;
    }

    public void setTimeFormat(String string) {
        this.m_TimeFormat = string;
    }

    public void setTimestampFormat(String string) {
        this.m_TimestampFormat = string;
    }

    public void add(String string, DataType dataType, DataAttributes dataAttributes) {
        this.add(new SchemaItem(string, dataType, dataAttributes));
    }

    public void add(SchemaItem schemaItem) {
        int n = this.m_Items.indexOf(schemaItem);
        if (n >= 0 && !this.m_AllowDuplicateNames) {
            this.m_Items.set(n, schemaItem);
        } else {
            this.m_Items.add(schemaItem);
        }
    }

    public void setDataType(int n, DataType dataType) {
        SchemaItem schemaItem = this.m_Items.get(n);
        this.m_Items.set(n, new SchemaItem(schemaItem.name, dataType, schemaItem.attrs));
    }

    public boolean contains(String string) {
        for (SchemaItem schemaItem : this.m_Items) {
            if (!string.equals(schemaItem.name)) continue;
            return true;
        }
        return false;
    }

    public void rename(String string, String string2) {
        for (int i = 0; i < this.m_Items.size(); ++i) {
            SchemaItem schemaItem = this.m_Items.get(i);
            if (!string.equals(schemaItem.name)) continue;
            this.m_Items.set(i, new SchemaItem(string2, schemaItem.type, schemaItem.attrs));
        }
    }

    public void discard(Set<String> set) {
        Iterator<SchemaItem> iterator = this.m_Items.iterator();
        while (iterator.hasNext()) {
            SchemaItem schemaItem = iterator.next();
            if (!set.contains(schemaItem.name)) continue;
            iterator.remove();
        }
    }

    public void discard(String string) {
        Iterator<SchemaItem> iterator = this.m_Items.iterator();
        while (iterator.hasNext()) {
            SchemaItem schemaItem = iterator.next();
            if (!string.equals(schemaItem.name)) continue;
            iterator.remove();
            break;
        }
    }

    public void retain(Set<String> set) {
        Iterator<SchemaItem> iterator = this.m_Items.iterator();
        while (iterator.hasNext()) {
            SchemaItem schemaItem = iterator.next();
            if (set.contains(schemaItem.name)) continue;
            iterator.remove();
        }
    }

    public void order(List<String> list) {
        if (!list.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SchemaItem object2 : this.m_Items) {
                arrayList.add(object2.name);
            }
            ArrayList<SchemaItem> arrayList2 = new ArrayList<SchemaItem>(this.m_Items);
            ArrayList<SchemaItem> arrayList3 = new ArrayList<SchemaItem>();
            for (String string : list) {
                int n = arrayList.indexOf(string);
                if (n < 0) continue;
                SchemaItem schemaItem = this.m_Items.get(n);
                arrayList3.add(schemaItem);
                arrayList2.remove(schemaItem);
            }
            arrayList3.addAll(arrayList2);
            this.m_Items.clear();
            this.m_Items.addAll(arrayList3);
        }
    }

    public void union(DataSchema dataSchema) {
        int n = dataSchema.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String string = dataSchema.getColumnName(i);
            DataType dataType = dataSchema.getColumnType(i);
            SchemaItem schemaItem = this.getItem(string);
            if (schemaItem == null) {
                this.add(string, dataType, new DataAttributes());
                continue;
            }
            SchemaItem schemaItem2 = new SchemaItem(schemaItem.name, this.generalize(schemaItem.type, dataType), new DataAttributes());
            this.replace(schemaItem, schemaItem2);
        }
    }

    public void intersect(DataSchema dataSchema) {
        int n = dataSchema.getColumnCount();
        ArrayList<SchemaItem> arrayList = new ArrayList<SchemaItem>();
        for (int i = 0; i < n; ++i) {
            String string = dataSchema.getColumnName(i);
            DataType dataType = dataSchema.getColumnType(i);
            SchemaItem schemaItem = this.getItem(string);
            if (schemaItem == null) continue;
            arrayList.add(new SchemaItem(schemaItem.name, this.generalize(schemaItem.type, dataType), new DataAttributes()));
        }
        this.m_Items.clear();
        this.m_Items.addAll(arrayList);
    }

    private void replace(SchemaItem schemaItem, SchemaItem schemaItem2) {
        int n = this.m_Items.indexOf(schemaItem);
        if (n < 0) {
            throw new IllegalArgumentException("item not found in schema");
        }
        this.m_Items.set(n, schemaItem2);
    }

    public int size() {
        return this.m_Items.size();
    }

    public DataSchema getSchema() {
        DataSchema dataSchema = new DataSchema(this.m_IsCaseSensitive, this.m_Items);
        dataSchema.setDateFormat(this.m_DateFormat);
        dataSchema.setTimeFormat(this.m_TimeFormat);
        dataSchema.setTimestampFormat(this.m_TimestampFormat);
        return dataSchema;
    }

    public SchemaItem getItem(String string) {
        for (SchemaItem schemaItem : this.m_Items) {
            if (!string.equals(schemaItem.name)) continue;
            return schemaItem;
        }
        return null;
    }

    public SchemaItem getItem(int n) {
        return this.m_Items.get(n);
    }

    protected DataType generalize(DataType dataType, DataType dataType2) {
        if (dataType == dataType2) {
            return dataType;
        }
        if (DataType.STRING == dataType || DataType.STRING == dataType2) {
            return DataType.STRING;
        }
        if (DataType.DOUBLE == dataType || DataType.DOUBLE == dataType2) {
            return DataType.DOUBLE;
        }
        if (DataType.LONG == dataType || DataType.LONG == dataType2) {
            return DataType.LONG;
        }
        if (DataType.TIMESTAMP == dataType || DataType.TIMESTAMP == dataType2) {
            return DataType.TIMESTAMP;
        }
        return DataType.STRING;
    }
}

