/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.data2.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class SortParameters {
    private Set<String> m_Names = new HashSet<String>();
    private List<Parameter> m_Parameters = new ArrayList<Parameter>();
    private List<Parameter> m_Deferred = new ArrayList<Parameter>();

    public static List<Parameter> sort(List<Parameter> list) {
        SortParameters sortParameters = new SortParameters(list);
        if (sortParameters.getDeferredCount() > 0) {
            SortError sortError = sortParameters.getSortError();
            throw new RuntimeException(sortError.getError());
        }
        return sortParameters.getParameters();
    }

    SortParameters(List<Parameter> list) {
        for (Parameter parameter : list) {
            this.addParameter(parameter);
        }
    }

    SortParameters() {
    }

    List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.m_Parameters);
    }

    private SortError getSortError() {
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (Parameter parameter : this.m_Deferred) {
            treeSet.add(parameter.getName());
            String[] stringArray = parameter.getDependencies();
            for (int i = 0; i < stringArray.length; ++i) {
                treeSet2.add(stringArray[i]);
            }
        }
        if (treeSet.containsAll(treeSet2)) {
            return new CyclicError(treeSet);
        }
        treeSet2.removeAll(treeSet);
        return new DependencyError(treeSet2);
    }

    int getDeferredCount() {
        return this.m_Deferred.size();
    }

    void addParameter(Parameter parameter) {
        if (this.satisfied(parameter)) {
            this.doAdd(parameter);
            this.checkDeferred();
        } else {
            this.m_Deferred.add(parameter);
        }
    }

    void doAdd(Parameter parameter) {
        this.m_Names.add(parameter.getName());
        this.m_Parameters.add(parameter);
    }

    void checkDeferred() {
        boolean bl = false;
        Iterator<Parameter> iterator = this.m_Deferred.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = iterator.next();
            if (!this.satisfied(parameter)) continue;
            iterator.remove();
            this.doAdd(parameter);
            bl = true;
        }
        if (bl) {
            this.checkDeferred();
        }
    }

    boolean satisfied(Parameter parameter) {
        String[] stringArray = parameter.getDependencies();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.m_Names.contains(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    private static abstract class SortError {
        protected Set<String> m_Names;

        public SortError(Set<String> set) {
            this.m_Names = set;
        }

        public abstract String getType();

        public String getError() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getType() + ": ");
            Iterator<String> iterator = this.m_Names.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            return stringBuffer.toString();
        }
    }

    private static class CyclicError
    extends SortError {
        public CyclicError(Set<String> set) {
            super(set);
        }

        @Override
        public String getType() {
            return "Cyclic Error";
        }
    }

    private static class DependencyError
    extends SortError {
        public DependencyError(Set<String> set) {
            super(set);
        }

        @Override
        public String getType() {
            return "Dependency Error";
        }
    }
}

