/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.attributes;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Namespace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Enumeration
extends DataAttribute {
    public static final String NAME = "Enumeration";
    public static final String NOMINAL = "Nominal";
    public static final String ORDINAL = "Ordinal";
    protected final String m_Type;
    protected final List<String> m_Choices;

    public static Enumeration newNominal(List<String> list) {
        return new Enumeration(NAME, NOMINAL, list);
    }

    public static Enumeration newOrdinal(List<String> list) {
        return new Enumeration(NAME, ORDINAL, list);
    }

    public static Enumeration newEnumeration(Element element) {
        Namespace namespace = element.getNamespace();
        String string = element.getAttributeValue("type");
        List<Element> list = element.getChildren("choice", namespace);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Element element2 : list) {
            arrayList.add(element2.getAttributeValue("value"));
        }
        return new Enumeration(NAME, string, arrayList);
    }

    public static Enumeration newEnumeration(String string) {
        int n = string.indexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        List<String> list = StringUtil.listOfSubstrings(string3, '|');
        return new Enumeration(NAME, string2, list);
    }

    private Enumeration(String string, String string2, List<String> list) {
        super(string);
        this.m_Type = string2;
        this.m_Choices = list;
    }

    @Override
    public String getMemento() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.getMemento());
        stringBuilder.append(this.m_Type);
        stringBuilder.append('.');
        Iterator<String> iterator = this.m_Choices.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append('|');
        }
        return stringBuilder.toString();
    }

    @Override
    public Element getElement() {
        Element element = super.getElement();
        element.setAttribute("type", this.m_Type);
        Iterator<String> iterator = this.m_Choices.iterator();
        while (iterator.hasNext()) {
            Element element2 = new Element("choice", Data2Constants.NS_DATASOURCE);
            element2.setAttribute("value", iterator.next());
            element.addContent(element2);
        }
        return element;
    }

    public String getType() {
        return this.m_Type;
    }

    public List<String> getChoices() {
        return Collections.unmodifiableList(this.m_Choices);
    }

    @Override
    public String getRenderableName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_Type);
        stringBuilder.append('[');
        Iterator<String> iterator = this.m_Choices.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public String getRenderableValue() {
        return this.getRenderableName();
    }
}

