/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.attributes;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.jdom.Element;

public class ForeignKey
extends DataAttribute {
    public static final String NAME = "ForeignKey";
    private final String m_Table;
    private final String m_Column;
    private final int m_Sequence;
    private final String m_ConstraintName;
    private final int m_UpdateRule;
    private final int m_DeleteRule;

    public static DataAttribute newForeignKey(Element element) {
        String string = element.getAttributeValue("table");
        String string2 = element.getAttributeValue("column");
        String string3 = element.getAttributeValue("constraint-name");
        int n = 0;
        int n2 = 3;
        int n3 = 3;
        try {
            n = Integer.parseInt(element.getAttributeValue("sequence"));
            n2 = Integer.parseInt(element.getAttributeValue("update-rule"));
            n3 = Integer.parseInt(element.getAttributeValue("delete-rule"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new ForeignKey(string, string2, n, string3, n2, n3);
    }

    public static DataAttribute newForeignKey(String string) {
        String[] stringArray = StringUtil.arrayOfSubstrings(string, '|');
        if (stringArray.length != 6) {
            return null;
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        int n = 0;
        int n2 = 3;
        int n3 = 3;
        try {
            n = Integer.parseInt(stringArray[2]);
            n2 = Integer.parseInt(stringArray[4]);
            n3 = Integer.parseInt(stringArray[5]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string4 = stringArray[3];
        if ("null".equalsIgnoreCase(string4)) {
            string4 = null;
        }
        return new ForeignKey(string2, string3, n, string4, n2, n3);
    }

    public ForeignKey(String string, String string2, int n) {
        this(string, string2, n, null, 3, 3);
    }

    public ForeignKey(String string, String string2, int n, String string3) {
        this(string, string2, n, string3, 3, 3);
    }

    public ForeignKey(String string, String string2, int n, String string3, int n2, int n3) {
        super(NAME);
        this.m_Table = string;
        this.m_Column = string2;
        this.m_Sequence = n;
        this.m_ConstraintName = string3;
        this.m_UpdateRule = n2;
        this.m_DeleteRule = n3;
    }

    public String getTable() {
        return this.m_Table;
    }

    public String getColumn() {
        return this.m_Column;
    }

    public int getSequence() {
        return this.m_Sequence;
    }

    public String getConstraintName() {
        return this.m_ConstraintName;
    }

    public int getUpdateRule() {
        return this.m_UpdateRule;
    }

    public int getDeleteRule() {
        return this.m_DeleteRule;
    }

    @Override
    public Element getElement() {
        Element element = super.getElement();
        element.setAttribute("table", this.m_Table);
        element.setAttribute("column", this.m_Column);
        element.setAttribute("sequence", String.valueOf(this.m_Sequence));
        if (this.m_ConstraintName != null) {
            element.setAttribute("constraint-name", String.valueOf(this.m_ConstraintName));
        }
        element.setAttribute("update-rule", String.valueOf(this.m_UpdateRule));
        element.setAttribute("delete-rule", String.valueOf(this.m_DeleteRule));
        return element;
    }

    @Override
    public String getMemento() {
        String string = super.getMemento();
        return string + this.m_Table + "|" + this.m_Column + "|" + this.m_Sequence + "|" + this.m_ConstraintName + "|" + this.m_UpdateRule + "|" + this.m_DeleteRule;
    }

    @Override
    public String getRenderableName() {
        return super.getRenderableName() + "-" + this.m_Table + ":" + this.m_Column + "(" + this.m_Sequence + ")";
    }

    @Override
    public String getRenderableValue() {
        return this.m_Table + ":" + this.m_Column + "(" + this.m_Sequence + ")";
    }
}

