/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.attributes;

import com.elixirtech.data2.DataAttribute;
import com.elixirtech.jdom.Element;

public class Nullable
extends DataAttribute {
    public static final String NAME = "Nullable";
    private final boolean m_IsNullable;

    public static DataAttribute newNullable(Element element) {
        boolean bl = "yes".equals(element.getAttributeValue("nullable"));
        return new Nullable(bl);
    }

    public static DataAttribute newNullable(String string) {
        boolean bl = "yes".equals(string);
        return new Nullable(bl);
    }

    public Nullable(boolean bl) {
        super(NAME);
        this.m_IsNullable = bl;
    }

    @Override
    public Element getElement() {
        Element element = super.getElement();
        element.setAttribute("nullable", this.m_IsNullable ? "yes" : "no");
        return element;
    }

    @Override
    public String getMemento() {
        return super.getMemento() + (this.m_IsNullable ? "yes" : "no");
    }

    public boolean isNullable() {
        return this.m_IsNullable;
    }

    @Override
    public String getRenderableName() {
        if (this.m_IsNullable) {
            return NAME;
        }
        return "NotNull";
    }

    @Override
    public String getRenderableValue() {
        if (this.m_IsNullable) {
            return NAME;
        }
        return "NotNull";
    }
}

