/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.attributes;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.jdom.Element;

public class Range
extends DataAttribute {
    public static final String NAME = "Range";
    private final String m_Start;
    private final String m_Stop;

    public static DataAttribute newRange(Element element) {
        return new Range(element.getAttributeValue("start"), element.getAttributeValue("stop"));
    }

    public static DataAttribute newRange(String string) {
        String[] stringArray = StringUtil.arrayOfSubstrings(string, '|');
        if (stringArray.length != 2) {
            return null;
        }
        return new Range(stringArray[0], stringArray[1]);
    }

    public Range(String string, String string2) {
        super(NAME);
        this.m_Start = string;
        this.m_Stop = string2;
    }

    public String getStart() {
        return this.m_Start;
    }

    public String getStop() {
        return this.m_Stop;
    }

    @Override
    public String getRenderableName() {
        return "Range(" + this.m_Start + ".." + this.m_Stop + ")";
    }

    @Override
    public String getRenderableValue() {
        return this.m_Start + ".." + this.m_Stop;
    }

    @Override
    public Element getElement() {
        Element element = super.getElement();
        element.setAttribute("start", this.m_Start);
        element.setAttribute("stop", this.m_Stop);
        return element;
    }

    @Override
    public String getMemento() {
        String string = super.getMemento();
        return string + this.m_Start + "|" + this.m_Stop;
    }
}

