/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.FileBasedDataSource;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.Argument;
import com.elixirtech.data2.datasource.NullDataSource;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class RefDataSource
extends FileBasedDataSource
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RefDataSource.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final DataSourceManager dsm;
    private String name;
    private String description;
    private String dsName;
    private boolean scoped;
    private Option<IDataSource> optDataSource;
    private Option<java.util.List<Parameter>> optParameters;
    private List<Argument> arguments;

    public RefDataSource(String n, DataSourceManager dsm, String dsn) {
        this.dsm = dsm;
        this.name = n;
        this.description = "";
        this.dsName = dsn;
        this.scoped = false;
        this.optDataSource = None$.MODULE$;
        this.optParameters = None$.MODULE$;
        this.arguments = package$.MODULE$.Nil();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getType() {
        return "Ref";
    }

    public void setName(String s) {
        this.name = s;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public boolean isScoped() {
        return this.scoped;
    }

    public void setScoped(boolean b) {
        this.scoped = b;
    }

    public void setDataSourceName(String s) {
        this.dsName = s;
        this.optDataSource = None$.MODULE$;
        this.optParameters = None$.MODULE$;
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    @Override
    public java.util.List<Parameter> getParameters() {
        Option<java.util.List<Parameter>> option = this.optParameters;
        if (option instanceof Some) {
            java.util.List params = (java.util.List)((Some)option).value();
            return params;
        }
        if (None$.MODULE$.equals(option)) {
            java.util.List<Parameter> ret = this.buildParameters();
            this.optParameters = Some$.MODULE$.apply(ret);
            return ret;
        }
        throw new MatchError(option);
    }

    private java.util.List<Parameter> buildParameters() {
        ArgumentMap map = new ArgumentMap();
        this.arguments.foreach((Function1 & Serializable)arg -> map.extractParameters(arg.getValue()));
        return map.getParameters();
    }

    public void removeAllArguments() {
        this.arguments = package$.MODULE$.Nil();
        this.optParameters = None$.MODULE$;
    }

    public void addArgument(String name, String value) {
        Argument argument = new Argument(name, value);
        this.arguments = this.arguments.$colon$colon((Object)argument);
        this.optParameters = None$.MODULE$;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    public DataSchema getSchema() {
        Option<IDataSource> option = this.optDataSource;
        if (option instanceof Some) {
            IDataSource ds = (IDataSource)((Some)option).value();
            return ds.getSchema();
        }
        if (None$.MODULE$.equals(option)) {
            Try try_ = Try$.MODULE$.apply(this::getSchema$$anonfun$1);
            if (try_ instanceof Success) {
                DataSchema s = (DataSchema)((Success)try_).value();
                return s;
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                this.log().error(() -> this.getSchema$$anonfun$2(ex), Line$.MODULE$.apply(91), FullName$.MODULE$.apply("com.elixirtech.data2.datasource.RefDataSource.getSchema"));
                return new DataSchema(true, (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), (DataType[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(DataType.class)));
            }
            throw new MatchError((Object)try_);
        }
        throw new MatchError(option);
    }

    @Override
    public void pushTo(PushContext cxt, DataListener dl) {
        ObjectRef pcxt = ObjectRef.create((Object)cxt);
        IDataSource ds = (IDataSource)this.optDataSource.getOrElse(() -> this.$anonfun$1(cxt));
        if (this.scoped) {
            scala.collection.immutable.Map map = this.arguments.map((Function1 & Serializable)arg -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)arg.getName());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)((PushContext)pcxt$1.elem).substitute(arg.getValue()));
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            PushContext pushContext = ((PushContext)pcxt.elem).subContext(CollectionConverters$.MODULE$.MapHasAsJava((Map)map).asJava());
            pcxt.elem = pushContext;
            pushContext = null;
        }
        ds.pushTo((PushContext)pcxt.elem, dl);
    }

    public IDataSource resolve(PushContext cxt) {
        String name = cxt.substitute(this.dsName);
        NullDataSource ds = StringUtil.isEmpty(name) ? new NullDataSource() : this.dsm.getDataSource(this.dsm, name);
        this.optDataSource = Some$.MODULE$.apply((Object)ds);
        return ds;
    }

    private final DataSchema getSchema$$anonfun$1() {
        return this.resolve(new DefaultPushContext()).getSchema();
    }

    private final Object getSchema$$anonfun$2(Throwable ex$1) {
        return "Can't locate datasource schema for " + this.dsName + ": " + ex$1;
    }

    private final IDataSource $anonfun$1(PushContext cxt$1) {
        return this.resolve(cxt$1);
    }
}

