/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.cache2;

import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.cache2.ICache;

public class MemoryCache
implements ICache {
    private final String m_CachePath;
    private final long m_Expiry;
    private final DataTable m_DataTable;
    private final String m_Memento;

    public MemoryCache(String string, long l, DataTable dataTable, String string2) {
        assert (string != null);
        assert (l >= 0L);
        assert (dataTable != null);
        assert (string2 != null);
        this.m_CachePath = string;
        this.m_Expiry = l;
        this.m_DataTable = dataTable;
        this.m_Memento = string2;
    }

    @Override
    public String getCachePath() {
        return this.m_CachePath;
    }

    @Override
    public boolean hasExpired() {
        if (this.m_Expiry == 0L) {
            return false;
        }
        long l = System.currentTimeMillis();
        return l > this.m_Expiry;
    }

    @Override
    public boolean isConsistent(DataSchema dataSchema) {
        return this.m_DataTable.getSchema().equals(dataSchema);
    }

    @Override
    public boolean isConsistent(String string) {
        return this.m_Memento.equals(string);
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        this.m_DataTable.pushTo(pushContext, dataListener);
    }

    public String getMemento() {
        return this.m_Memento;
    }

    public String toString() {
        return this.m_CachePath + ":" + this.m_Memento;
    }
}

