/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.codec;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.datasource.composite.DataStoreCodec;
import com.elixirtech.jdom.Element;

public class CSVCodec
implements DataStoreCodec {
    @Override
    public DataStore buildDataStore(Element element) {
        DataStore dataStore = new DataStore("CSV File");
        Element element2 = element.getChild("csv", Data2Constants.NS_DATASOURCE);
        if (element2 != null) {
            dataStore.setProperty("CSV_URL", element2.getAttributeValue("url"));
            dataStore.setProperty("CSV_Separator", element2.getAttributeValue("separator"));
            dataStore.setProperty("CSV_Qualifier", element2.getAttributeValue("qualifier"));
            dataStore.setProperty("CSV_Append", element2.getAttributeValue("append"));
        }
        return dataStore;
    }

    @Override
    public Element buildElement(Node node) {
        Element element = new Element("csv", Data2Constants.NS_DATASOURCE);
        element.setAttribute("url", this.notNull(node.getUserProperty("CSV_URL")));
        element.setAttribute("separator", this.notNull(node.getUserProperty("CSV_Separator")));
        element.setAttribute("qualifier", this.notNull(node.getUserProperty("CSV_Qualifier")));
        element.setAttribute("append", this.notNull(node.getUserProperty("CSV_Append")));
        return element;
    }

    private String notNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

