/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.codec;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.datasource.composite.DataStoreCodec;
import com.elixirtech.jdom.Element;

public class JDBCJNDICodec
implements DataStoreCodec {
    @Override
    public DataStore buildDataStore(Element element) {
        DataStore dataStore = new DataStore("JDBC JNDI");
        Element element2 = element.getChild("jdbc-jndi", Data2Constants.NS_DATASOURCE);
        if (element2 != null) {
            dataStore.setProperty("JDBC_ContextFactory", element2.getAttributeValue("context-factory"));
            dataStore.setProperty("JDBC_Resource", element2.getAttributeValue("resource"));
            dataStore.setProperty("JDBC_Append", element2.getAttributeValue("append"));
            dataStore.setProperty("JDBC_Dialect", element2.getAttributeValue("dialect"));
            dataStore.setProperty("JDBC_Exists", element2.getAttributeValue("exists"));
            dataStore.setProperty("JDBC_Password", element2.getAttributeValue("password"));
            dataStore.setProperty("JDBC_TableName", element2.getAttributeValue("table"));
            dataStore.setProperty("JDBC_URL", element2.getAttributeValue("url"));
            dataStore.setProperty("JDBC_User", element2.getAttributeValue("user"));
            dataStore.setProperty("JDBC_AutoCommit", this.notNull(element2.getAttributeValue("auto-commit")));
            dataStore.setProperty("JDBC_UpdateInsert", this.notNull(element2.getAttributeValue("update-insert")));
            dataStore.setProperty("JDBC_ReturnKeys", this.notNull(element2.getAttributeValue("return-keys")));
            dataStore.setProperty("JDBC_ErrorStoreURL", this.notNull(element2.getAttributeValue("error-store-url")));
        }
        return dataStore;
    }

    @Override
    public Element buildElement(Node node) {
        Element element = new Element("jdbc-jndi", Data2Constants.NS_DATASOURCE);
        element.setAttribute("context-factory", this.notNull(node.getUserProperty("JDBC_ContextFactory")));
        element.setAttribute("resource", this.notNull(node.getUserProperty("JDBC_Resource")));
        element.setAttribute("append", this.notNull(node.getUserProperty("JDBC_Append")));
        element.setAttribute("dialect", this.notNull(node.getUserProperty("JDBC_Dialect")));
        element.setAttribute("exists", this.notNull(node.getUserProperty("JDBC_Exists")));
        element.setAttribute("password", this.notNull(node.getUserProperty("JDBC_Password")));
        element.setAttribute("table", this.notNull(node.getUserProperty("JDBC_TableName")));
        element.setAttribute("url", this.notNull(node.getUserProperty("JDBC_URL")));
        element.setAttribute("user", this.notNull(node.getUserProperty("JDBC_User")));
        element.setAttribute("auto-commit", this.notNull(node.getUserProperty("JDBC_AutoCommit")));
        element.setAttribute("update-insert", this.notNull(node.getUserProperty("JDBC_UpdateInsert")));
        element.setAttribute("return-keys", this.notNull(node.getUserProperty("JDBC_ReturnKeys")));
        element.setAttribute("error-store-url", this.notNull(node.getUserProperty("JDBC_ErrorStoreURL")));
        return element;
    }

    private String notNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

