/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.codec;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.datasource.composite.DataStoreCodec;
import com.elixirtech.jdom.Element;
import java.util.Map;

public class JavaCodec
implements DataStoreCodec {
    @Override
    public DataStore buildDataStore(Element element) {
        DataStore dataStore = new DataStore("Custom Java DataStore");
        Element element2 = element.getChild("java", Data2Constants.NS_DATASOURCE);
        if (element2 != null) {
            dataStore.setProperty("Java_ClassName", element2.getAttributeValue("class"));
            for (Element element3 : element2.getChildren("property", Data2Constants.NS_DATASOURCE)) {
                String string = element3.getAttributeValue("name");
                String string2 = element3.getText();
                dataStore.setProperty("Java_" + string, string2);
            }
        }
        return dataStore;
    }

    @Override
    public Element buildElement(Node node) {
        Element element = new Element("java", Data2Constants.NS_DATASOURCE);
        element.setAttribute("class", node.getUserProperty("Java_ClassName"));
        Map<String, String> map = node.getUserProperties();
        for (String string : map.keySet()) {
            if (!string.startsWith("Java_") || string.equals("Java_ClassName")) continue;
            String string2 = string.substring(5);
            Element element2 = new Element("property", Data2Constants.NS_DATASOURCE);
            element2.setAttribute("name", string2);
            element2.setText(map.get(string));
            element.addContent(element2);
        }
        return element;
    }
}

