/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.composite;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.ensemble.canvas.InOutGO;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class CompositeScope
extends ScriptableObject {
    private CompositeDataSource m_Composite;
    private Map<String, InOutGO> m_GOMap;
    private Map<String, Object> m_Properties = new HashMap<String, Object>();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CompositeScope.class);

    public CompositeScope(CompositeDataSource compositeDataSource) {
        this.m_Composite = compositeDataSource;
        this.m_GOMap = compositeDataSource.getGOMap();
    }

    public String getClassName() {
        return "CompositeScope";
    }

    public boolean has(String string, Scriptable scriptable) {
        if (this.localHas(string, scriptable)) {
            return true;
        }
        return super.has(string, scriptable);
    }

    private boolean localHas(String string, Scriptable scriptable) {
        if (this.m_Properties.containsKey(string)) {
            return true;
        }
        if (this.m_GOMap.containsKey(string)) {
            AccessController.doPrivileged(new HasAction(string));
            return true;
        }
        return false;
    }

    public Object get(String string, Scriptable scriptable) {
        if (this.localHas(string, scriptable)) {
            Object object = this.m_Properties.get(string);
            if (object instanceof Character) {
                object = String.valueOf(((Character)object).charValue());
            } else if (object instanceof BigDecimal) {
                Context context = Context.getCurrentContext();
                object = context.getWrapFactory().wrap(context, (Scriptable)this, object, null);
            }
            return object;
        }
        return super.get(string, scriptable);
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (this.m_Properties.containsKey(string)) {
            this.m_Properties.put(string, object);
        } else {
            super.put(string, scriptable, object);
        }
    }

    public void addProperty(String string, Object object) {
        this.m_Properties.put(string, object);
    }

    public void removeProperty(String string) {
        this.m_Properties.remove(string);
    }

    private class HasAction
    implements PrivilegedAction<Boolean> {
        private final String m_Name;

        public HasAction(String string) {
            this.m_Name = string;
        }

        @Override
        public Boolean run() {
            try {
                InOutGO inOutGO = CompositeScope.this.m_GOMap.get(this.m_Name);
                IDataSource iDataSource = CompositeScope.this.m_Composite.getDataSource(inOutGO);
                if (iDataSource != null) {
                    DataTable dataTable = DataTable.build(iDataSource);
                    CompositeScope.this.m_Properties.put(this.m_Name, dataTable);
                    return Boolean.TRUE;
                }
            }
            catch (Exception exception) {
                m_Log.error((Object)("Can't load DataSource for GO \"" + this.m_Name + "\": " + exception), (Throwable)exception);
            }
            return Boolean.FALSE;
        }
    }
}

