/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.composite;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.ensemble.ds.DSUtil;

public class EnsembleRuntime {
    private DataSourceManager m_DSM;
    private PushContext m_PushContext;

    public EnsembleRuntime(DataSourceManager dataSourceManager) {
        this.m_DSM = dataSourceManager;
        this.m_PushContext = new DefaultPushContext();
    }

    public EnsembleRuntime(DataSourceManager dataSourceManager, PushContext pushContext) {
        this.m_DSM = dataSourceManager;
        this.m_PushContext = pushContext;
    }

    public CompositeDataSource getDataSource(String string) throws DataException {
        IDataSource iDataSource = this.m_DSM.getDataSource(this.m_DSM, string);
        if (iDataSource == null) {
            throw new DataException("CompositeDataSource " + string + " not found");
        }
        if (iDataSource instanceof CompositeDataSource) {
            return (CompositeDataSource)iDataSource;
        }
        throw new DataException(string + " is not a CompositeDataSource, it is a " + iDataSource.getType());
    }

    public void generate(CompositeDataSource compositeDataSource, String string) throws DataException {
        DataStore dataStore = this.getDataStore(compositeDataSource, string);
        if (dataStore == null) {
            throw new DataException("Store name " + string + " not found");
        }
        DSUtil.generate(compositeDataSource, this.m_PushContext, dataStore);
    }

    private DataStore getDataStore(CompositeDataSource compositeDataSource, String string) {
        for (DataStore dataStore : compositeDataSource.getDataStores()) {
            if (!string.equals(dataStore.getName())) continue;
            return dataStore;
        }
        return null;
    }
}

