/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.composite;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.composite.InputDataSource;
import com.elixirtech.jdom.Element;
import java.util.List;

public class InputDefinition
extends DataSourceDefinition {
    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        Element element2 = element.getChild("input", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load input element");
        }
        IDataSource iDataSource = this.getParent(dataSourceManager, element2);
        InputDataSource inputDataSource = new InputDataSource(string, iDataSource);
        for (Element element3 : element2.getChildren("test", NS_DATASOURCE)) {
            String string2 = element3.getAttributeValue("name");
            String string3 = element3.getText();
            inputDataSource.addTest(string2, string3);
        }
        return inputDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof InputDataSource)) {
            throw new IllegalArgumentException("Not an InputDataSource");
        }
        InputDataSource inputDataSource = (InputDataSource)iDataSource;
        Element element = this.defineDataSource(inputDataSource);
        Element element2 = new Element("input", NS_DATASOURCE);
        element2.setAttribute("parent", inputDataSource.getParent().getName());
        List<InputDataSource.Test> list = inputDataSource.getTests();
        for (InputDataSource.Test test : list) {
            Element element3 = new Element("test", NS_DATASOURCE);
            element3.setAttribute("name", test.name);
            element3.addContent(test.test);
            element2.addContent(element3);
        }
        element.addContent(element2);
        return element;
    }
}

