/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.composite;

import com.elixirtech.data2.AbstractDataSource;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.datasource.composite.InputDataSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OutputDataSource
extends AbstractDataSource {
    private String m_Name;
    private String m_Description;
    private InputDataSource m_Input;
    private List<IDataSource> m_Parents = new ArrayList<IDataSource>();

    public OutputDataSource(String string, InputDataSource inputDataSource) {
        this.m_Name = string;
        this.m_Input = inputDataSource;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    @Override
    public String getType() {
        return "Output";
    }

    @Override
    public DataSchema getSchema() {
        SchemaBuilder schemaBuilder = new SchemaBuilder(true);
        for (IDataSource iDataSource : this.m_Parents) {
            schemaBuilder.union(iDataSource.getSchema());
        }
        return schemaBuilder.getSchema();
    }

    public void addParent(IDataSource iDataSource) {
        assert (iDataSource != null);
        this.m_Parents.add(iDataSource);
    }

    public InputDataSource getInput() {
        return this.m_Input;
    }

    public Iterator<IDataSource> getParents() {
        return this.m_Parents.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        this.m_Input.enablePushThrough(true);
        try {
            RecordDL recordDL = new RecordDL(dataListener);
            for (IDataSource iDataSource : this.m_Parents) {
                iDataSource.pushTo(pushContext, recordDL);
            }
            this.m_Input.pushThrough(pushContext, new StructureDL(dataListener));
        }
        finally {
            this.m_Input.enablePushThrough(false);
        }
    }

    private class RecordDL
    implements DataListener2 {
        private DataListener m_DL;
        private DataSchema m_Schema;

        public RecordDL(DataListener dataListener) {
            this.m_DL = dataListener;
        }

        @Override
        public <T> T getAdapter(Class<T> clazz) {
            if (clazz == IDataSource.class) {
                return clazz.cast(OutputDataSource.this);
            }
            return null;
        }

        @Override
        public void startData(IDataSource iDataSource) {
        }

        @Override
        public void startGroup(DataGroup dataGroup) {
        }

        @Override
        public boolean processRecord(DataRecord dataRecord) {
            if (this.m_Schema == null) {
                this.m_Schema = OutputDataSource.this.getSchema();
            }
            Object[] objectArray = new Object[this.m_Schema.getColumnCount()];
            DataRecord dataRecord2 = new DataRecord(this.m_Schema, objectArray);
            DataSchema dataSchema = dataRecord.getSchema();
            for (Object objectArray[this.m_Schema.getColumnIndex((String)dataSchema.getColumnName((int)var7_7))] : dataRecord.getData()) {
            }
            return this.m_DL.processRecord(dataRecord2);
        }

        @Override
        public void endGroup(DataGroup dataGroup) {
        }

        @Override
        public void endData(IDataSource iDataSource) {
        }
    }

    private class StructureDL
    implements DataListener2 {
        private DataListener m_DL;

        public StructureDL(DataListener dataListener) {
            this.m_DL = dataListener;
        }

        @Override
        public <T> T getAdapter(Class<T> clazz) {
            if (clazz == IDataSource.class) {
                return clazz.cast(OutputDataSource.this);
            }
            return null;
        }

        @Override
        public void startData(IDataSource iDataSource) {
            this.m_DL.startData(OutputDataSource.this);
        }

        @Override
        public void startGroup(DataGroup dataGroup) {
            this.m_DL.startGroup(dataGroup);
        }

        @Override
        public boolean processRecord(DataRecord dataRecord) {
            return true;
        }

        @Override
        public void endGroup(DataGroup dataGroup) {
            this.m_DL.endGroup(dataGroup);
        }

        @Override
        public void endData(IDataSource iDataSource) {
            this.m_DL.endData(OutputDataSource.this);
        }
    }
}

