/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.concat;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.concat.ConcatDataSource;
import com.elixirtech.jdom.Element;

public class ConcatDefinition
extends DataSourceDefinition {
    public static final String CONCAT_TYPE = "concat-type";

    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        ConcatDataSource concatDataSource = new ConcatDataSource();
        concatDataSource.setName(element.getAttributeValue("name"));
        Element element2 = element.getChild("concat", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load concat element");
        }
        concatDataSource.setConcatType(element2.getAttributeValue(CONCAT_TYPE));
        for (Element element3 : element2.getChildren("source", NS_DATASOURCE)) {
            concatDataSource.addDataSource(this.getParent(dataSourceManager, element3));
        }
        return concatDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof ConcatDataSource)) {
            throw new IllegalArgumentException("Not a ConcatDataSource");
        }
        ConcatDataSource concatDataSource = (ConcatDataSource)iDataSource;
        Element element = this.defineDataSource(concatDataSource);
        Element element2 = new Element("concat", NS_DATASOURCE);
        element2.setAttribute(CONCAT_TYPE, concatDataSource.getConcatType());
        for (IDataSource iDataSource2 : concatDataSource.getDataSources()) {
            Element element3 = new Element("source", NS_DATASOURCE);
            element3.setAttribute("parent", iDataSource2.getName());
            element2.addContent(element3);
        }
        element.addContent(element2);
        return element;
    }
}

