/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.dataset;

import ambience.api.DSBridge$;
import com.elixirtech.arch.Holder;
import com.elixirtech.arch.Holder$;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.ArgumentMap$;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.FileBasedDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.dataset.DatasetDataSource$;
import com.elixirtech.data2.iterator.IDataRecordIterable;
import java.io.Serializable;
import java.util.List;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;

public class DatasetDataSource
extends FileBasedDataSource {
    private final Holder<String> m_Name = new Holder(Holder$.MODULE$.$lessinit$greater$default$1());
    private final Holder<String> m_Description = new Holder(Holder$.MODULE$.$lessinit$greater$default$1());
    private final Holder<String> m_Dataset = new Holder(Holder$.MODULE$.$lessinit$greater$default$1());
    private final Holder<String> m_InParameters = new Holder(Holder$.MODULE$.$lessinit$greater$default$1());
    private final Holder<DataSchema> m_Schema = new Holder(Holder$.MODULE$.$lessinit$greater$default$1());

    public static String Type() {
        return DatasetDataSource$.MODULE$.Type();
    }

    @Override
    public <T> T getAdapter(Class<T> cls) {
        Class<T> clazz = cls;
        Class<IDataRecordIterable> clazz2 = IDataRecordIterable.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return cls.cast(this);
        }
        return super.getAdapter(cls);
    }

    @Override
    public String getName() {
        return this.m_Name.value();
    }

    @Override
    public String getDescription() {
        return this.m_Description.value();
    }

    public String getDataset() {
        return this.m_Dataset.value();
    }

    public String getInParameters() {
        return this.m_InParameters.value();
    }

    public void setName(String name) {
        this.update(this.m_Name, name);
    }

    public void setDescription(String desc) {
        this.update(this.m_Description, desc);
    }

    public void setSchema(DataSchema schema) {
        this.update(this.m_Schema, schema);
    }

    public void setDataset(String ds) {
        this.update(this.m_Dataset, ds);
    }

    public void setInParameters(String ip) {
        this.update(this.m_InParameters, ip);
    }

    @Override
    public String getType() {
        return DatasetDataSource$.MODULE$.Type();
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap map = new ArgumentMap();
        map.extractParameters(this.m_InParameters.value());
        return map.getParameters();
    }

    @Override
    public DataSchema getSchema() {
        return this.m_Schema.value();
    }

    @Override
    public void pushTo(PushContext cxt, DataListener dl) throws DataException {
        String inParams = this.substitute(cxt, this.m_InParameters.value());
        try {
            Iterator<DataRecord> it = DSBridge$.MODULE$.getInstance().getRecords(this.m_Dataset.value(), this.m_Schema.value(), inParams);
            dl.startData(this);
            try {
                it.foreach((Function1 & Serializable)doc -> dl.processRecord((DataRecord)doc));
            }
            finally {
                dl.endData(this);
            }
        }
        catch (Exception ex) {
            throw new DataException("Can't read from Dataset: " + ex, ex);
        }
    }

    public String substitute(PushContext cxt, String s) {
        ArgumentMap.ICallback wrapper = new ArgumentMap.ICallback(cxt){
            private final PushContext cxt$1;
            {
                this.cxt$1 = cxt$2;
            }

            public String getValue(String name, String type) {
                String result = this.cxt$1.getValue(name, type);
                return result.replace("\"", "\\\"");
            }
        };
        return ArgumentMap$.MODULE$.substitute(s, wrapper);
    }

    public DataSchema inferSchema(PushContext cxt) throws DataException {
        DataSchema dataSchema;
        try {
            DataSchema schema;
            Option<DataSchema> option = DSBridge$.MODULE$.getInstance().schema(this.m_Dataset.value());
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new DataException("Can't get Dataset schema: " + this.m_Dataset.value());
                }
                throw new MatchError(option);
            }
            dataSchema = schema = (DataSchema)((Some)option).value();
        }
        catch (Exception ex) {
            throw new DataException("Can't read schema: " + ex, ex);
        }
        return dataSchema;
    }

    private <T> boolean changed(Holder<T> o1, T o2) {
        if (!o1.isDefined()) {
            return o2 != null;
        }
        return !o1.equals(o2);
    }

    private <T> void update(Holder<T> o1, T o2) {
        if (this.changed(o1, o2)) {
            o1.set(o2);
            this.setDirty(true);
            return;
        }
    }
}

