/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.derivative;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.derivative.CrossJoinDerivative;
import com.elixirtech.data2.datasource.derivative.Derivative;
import com.elixirtech.data2.datasource.derivative.DerivedDataSource;
import com.elixirtech.data2.datasource.derivative.JavaScriptDerivative;
import com.elixirtech.data2.datasource.derivative.JoinDerivative;
import com.elixirtech.data2.datasource.derivative.Prefix;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Namespace;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DerivativeDefinition
extends DataSourceDefinition {
    public static final String PREFIX = "prefix";
    public static final String ZERO = "zero";
    public static final String MULTIPLE = "multiple";

    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        Element element2 = element.getChild("derivative", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load derivative element");
        }
        IDataSource iDataSource = this.getParent(dataSourceManager, element2);
        DerivedDataSource derivedDataSource = new DerivedDataSource(string, iDataSource);
        String string2 = element2.getAttributeValue(PREFIX);
        derivedDataSource.setPrefix(Prefix.getInstance(string2));
        derivedDataSource.setDiscardSet(this.buildDiscardSet(element2));
        for (Element element3 : element2.getChildren()) {
            String string3 = element3.getName();
            if ("javascript".equals(string3)) {
                this.buildJavaScript(derivedDataSource, element3);
                continue;
            }
            if ("join".equals(string3)) {
                this.buildJoin(dataSourceManager, derivedDataSource, element3);
                continue;
            }
            if (!"cross-join".equals(string3)) continue;
            this.buildCrossJoin(dataSourceManager, derivedDataSource, element3);
        }
        return derivedDataSource;
    }

    private void buildCrossJoin(DataSourceManager dataSourceManager, DerivedDataSource derivedDataSource, Element element) throws DataException {
        IDataSource iDataSource = this.getParent(dataSourceManager, element);
        CrossJoinDerivative crossJoinDerivative = new CrossJoinDerivative(iDataSource);
        String string = element.getAttributeValue(PREFIX);
        if (string != null) {
            crossJoinDerivative.setPrefix(string);
        }
        crossJoinDerivative.setDiscardSet(this.buildDiscardSet(element));
        derivedDataSource.addDerivative(crossJoinDerivative);
    }

    private void buildJavaScript(DerivedDataSource derivedDataSource, Element element) {
        Element element2 = element.getChild("pre-processing", NS_DATASOURCE);
        String string = element2 != null ? element2.getText() : null;
        Iterator<Element> iterator = element.getChildren("column", NS_DATASOURCE).iterator();
        if (StringUtil.notEmpty(string) || iterator.hasNext()) {
            JavaScriptDerivative javaScriptDerivative = new JavaScriptDerivative();
            while (iterator.hasNext()) {
                Element element3 = iterator.next();
                String string2 = element3.getAttributeValue("name");
                DataType dataType = DataType.getInstance(element3.getAttributeValue("type"));
                String string3 = element3.getAttributeValue("script");
                javaScriptDerivative.addColumn(string2, dataType, string3);
            }
            javaScriptDerivative.setPreProcessing(string);
            derivedDataSource.addDerivative(javaScriptDerivative);
        }
    }

    private void buildJoin(DataSourceManager dataSourceManager, DerivedDataSource derivedDataSource, Element element) throws DataException {
        String string;
        IDataSource iDataSource = this.getParent(dataSourceManager, element);
        JoinDerivative joinDerivative = new JoinDerivative(iDataSource);
        String string2 = element.getAttributeValue(PREFIX);
        joinDerivative.setPrefix(Prefix.getInstance(string2));
        String string3 = element.getAttributeValue(ZERO);
        if (string3 != null) {
            joinDerivative.setZeroAction(string3);
        }
        if ((string = element.getAttributeValue(MULTIPLE)) != null) {
            joinDerivative.setMultipleAction(string);
        }
        for (Element element2 : element.getChildren("key", NS_DATASOURCE)) {
            String string4 = element2.getAttributeValue("primary");
            String string5 = element2.getAttributeValue("secondary");
            joinDerivative.addJoin(string4, string5);
        }
        joinDerivative.setDiscardSet(this.buildDiscardSet(element));
        derivedDataSource.addDerivative(joinDerivative);
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof DerivedDataSource)) {
            throw new IllegalArgumentException("Not a DerivedDataSource");
        }
        DerivedDataSource derivedDataSource = (DerivedDataSource)iDataSource;
        Element element = this.defineDataSource(derivedDataSource);
        Element element2 = new Element("derivative", NS_DATASOURCE);
        element2.setAttribute("parent", derivedDataSource.getParent().getName());
        element2.setAttribute(PREFIX, derivedDataSource.getPrefix().string());
        this.writeDiscardSet(element2, derivedDataSource.getDiscardSet());
        DataSchema dataSchema = derivedDataSource.getSchema();
        int n = derivedDataSource.getDerivativeCount();
        for (int i = 0; i < n; ++i) {
            Derivative derivative = derivedDataSource.getDerivative(i);
            Element element3 = this.getItem(dataSchema, derivative);
            if (element3 == null) continue;
            element2.addContent(element3);
        }
        element.addContent(element2);
        return element;
    }

    protected Element getItem(DataSchema dataSchema, Derivative derivative) {
        Element element = null;
        if (derivative instanceof JavaScriptDerivative) {
            element = this.getJavaScriptItem(derivative);
        } else if (derivative instanceof JoinDerivative) {
            element = this.getJoinItem(derivative);
        } else if (derivative instanceof CrossJoinDerivative) {
            element = this.getCrossJoinItem(derivative);
        }
        return element;
    }

    private Element getCrossJoinItem(Derivative derivative) {
        CrossJoinDerivative crossJoinDerivative = (CrossJoinDerivative)derivative;
        Element element = new Element("cross-join", NS_DATASOURCE);
        element.setAttribute("parent", crossJoinDerivative.getSecondaryName());
        element.setAttribute(PREFIX, crossJoinDerivative.getPrefix());
        this.writeDiscardSet(element, crossJoinDerivative.getDiscardSet());
        return element;
    }

    private Element getJoinItem(Derivative derivative) {
        JoinDerivative joinDerivative = (JoinDerivative)derivative;
        Element element = new Element("join", NS_DATASOURCE);
        element.setAttribute("parent", joinDerivative.getSecondaryName());
        element.setAttribute(PREFIX, joinDerivative.getPrefix().string());
        element.setAttribute(ZERO, joinDerivative.getZeroAction());
        element.setAttribute(MULTIPLE, joinDerivative.getMultipleAction());
        this.writeDiscardSet(element, joinDerivative.getDiscardSet());
        for (JoinDerivative.JoinInfo joinInfo : joinDerivative.getJoins()) {
            Element element2 = new Element("key", NS_DATASOURCE);
            element2.setAttribute("primary", joinInfo.primary);
            element2.setAttribute("secondary", joinInfo.secondary);
            element.addContent(element2);
        }
        return element;
    }

    private Element getJavaScriptItem(Derivative derivative) {
        JavaScriptDerivative javaScriptDerivative = (JavaScriptDerivative)derivative;
        Element element = new Element("javascript", NS_DATASOURCE);
        String string = javaScriptDerivative.getPreProcessing();
        if (StringUtil.notEmpty(string)) {
            Element element2 = new Element("pre-processing", NS_DATASOURCE);
            element2.setAttribute("space", "preserve", Namespace.XML_NAMESPACE);
            element2.setText(string);
            element.addContent(element2);
        }
        int n = javaScriptDerivative.getColumnCount();
        for (int i = 0; i < n; ++i) {
            Element element3 = new Element("column", NS_DATASOURCE);
            JavaScriptDerivative.Column column = javaScriptDerivative.getColumn(i);
            element3.setAttribute("name", column.name);
            element3.setAttribute("type", column.type.getTypeName());
            element3.setAttribute("script", column.script);
            element.addContent(element3);
        }
        return element;
    }

    protected Set<String> buildDiscardSet(Element element) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Element element2 : element.getChildren("discard", NS_DATASOURCE)) {
            hashSet.add(element2.getAttributeValue("name"));
        }
        return hashSet;
    }

    protected void writeDiscardSet(Element element, Set<String> set) {
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            Element element2 = new Element("discard", NS_DATASOURCE);
            element2.setAttribute("name", iterator.next());
            element.addContent(element2);
        }
    }
}

