/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.discard;

import com.elixirtech.data2.AbstractDataSource;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DiscardDataSource
extends AbstractDataSource {
    private String m_Name;
    private IDataSource m_Parent;
    private Set<String> m_DiscardSet = Collections.emptySet();
    private List<String> m_OrderList = Collections.emptyList();
    private String m_Description;

    public DiscardDataSource(String string, IDataSource iDataSource) {
        this.m_Name = string;
        this.m_Parent = iDataSource;
    }

    public IDataSource getParent() {
        return this.m_Parent;
    }

    public void setParent(IDataSource iDataSource) {
        this.m_Parent = iDataSource;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    @Override
    public String getType() {
        return "Discard";
    }

    @Override
    public DataSchema getSchema() {
        if (this.m_Parent == null) {
            return null;
        }
        return DiscardDataSource.getSchema(this.m_Parent.getSchema(), this.m_DiscardSet, this.m_OrderList);
    }

    public static DataSchema getSchema(DataSchema dataSchema, Set<String> set, List<String> list) {
        if (set.isEmpty() && list.isEmpty()) {
            return dataSchema;
        }
        SchemaBuilder schemaBuilder = new SchemaBuilder(true, true);
        schemaBuilder.add(dataSchema);
        schemaBuilder.discard(set);
        schemaBuilder.order(list);
        return schemaBuilder.getSchema();
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        if (this.m_DiscardSet.isEmpty() && this.m_OrderList.isEmpty()) {
            this.m_Parent.pushTo(pushContext, dataListener);
        } else {
            this.m_Parent.pushTo(pushContext, new Discarder(this, this.m_DiscardSet, this.m_OrderList, dataListener));
        }
    }

    public Set<String> getDiscardSet() {
        return this.m_DiscardSet;
    }

    public void setDiscardSet(Set<String> set) {
        this.m_DiscardSet = set;
    }

    public List<String> getOrderList() {
        return this.m_OrderList;
    }

    public void setOrderList(List<String> list) {
        this.m_OrderList = list;
    }

    public void setName(String string) {
        this.m_Name = string;
    }

    public void setDescription(String string) {
        this.m_Description = string;
    }

    public static class Discarder
    implements DataListener2 {
        private final IDataSource m_Owner;
        private final DataListener m_DataListener;
        private final Set<String> m_DiscardSet;
        private final List<String> m_OrderList;
        private int[] m_Mapping;
        private DataSchema m_ChildSchema;

        public Discarder(IDataSource iDataSource, Set<String> set, List<String> list, DataListener dataListener) {
            this.m_Owner = iDataSource;
            this.m_DiscardSet = set;
            this.m_OrderList = list;
            this.m_DataListener = dataListener;
        }

        @Override
        public <T> T getAdapter(Class<T> clazz) {
            if (clazz == IDataSource.class) {
                return clazz.cast(this.m_Owner);
            }
            return null;
        }

        @Override
        public void startData(IDataSource iDataSource) {
            DataSchema dataSchema = iDataSource.getSchema();
            this.m_ChildSchema = DiscardDataSource.getSchema(dataSchema, this.m_DiscardSet, this.m_OrderList);
            this.m_Mapping = new int[this.m_ChildSchema.getColumnCount()];
            for (int i = 0; i < this.m_Mapping.length; ++i) {
                this.m_Mapping[i] = dataSchema.getColumnIndex(this.m_ChildSchema.getColumnName(i));
            }
            this.m_DataListener.startData(this.m_Owner);
        }

        @Override
        public void startGroup(DataGroup dataGroup) {
            this.m_DataListener.startGroup(dataGroup);
        }

        @Override
        public boolean processRecord(DataRecord dataRecord) {
            Object[] objectArray = dataRecord.getData();
            Object[] objectArray2 = new Object[this.m_ChildSchema.getColumnCount()];
            for (int i = 0; i < this.m_Mapping.length; ++i) {
                objectArray2[i] = objectArray[this.m_Mapping[i]];
            }
            return this.m_DataListener.processRecord(new DataRecord(this.m_ChildSchema, objectArray2));
        }

        @Override
        public void endGroup(DataGroup dataGroup) {
            this.m_DataListener.endGroup(dataGroup);
        }

        @Override
        public void endData(IDataSource iDataSource) {
            this.m_DataListener.endData(this.m_Owner);
        }
    }
}

