/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.excel;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.datasource.excel.ExcelDataSource;
import com.elixirtech.data2.datasource.excel.Range;
import com.elixirtech.data2.datasource.excel.XRangeBuilder;
import com.elixirtech.data2.xlsx.Cell;
import com.elixirtech.data2.xlsx.Sheet;
import com.elixirtech.data2.xlsx.Workbook;
import com.elixirtech.data2.xlsx.XLSXReader;
import java.io.IOException;
import java.io.InputStream;

public class XInferSchema {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(XInferSchema.class);

    public static DataSchema inferSchema(PushContext pushContext, ExcelDataSource excelDataSource) {
        block7: {
            String string = pushContext.substitute(excelDataSource.getURL());
            String string2 = pushContext.substitute(excelDataSource.getRange());
            InputStream inputStream = null;
            Workbook workbook = null;
            try {
                inputStream = URLLoader.getInputStream(string);
                workbook = XLSXReader.read(inputStream);
                Range range = XRangeBuilder.getRange(workbook, string2);
                if (!Range.isValid(range)) break block7;
                Sheet sheet = workbook.getSheet(range.firstSheet);
                SchemaBuilder schemaBuilder = new SchemaBuilder(true);
                try {
                    XInferSchema.buildSchema(excelDataSource, range, sheet, schemaBuilder);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                return schemaBuilder.getSchema();
            }
            catch (Exception exception) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                m_Log.error((Object)("Error reading workbook " + string + ": " + exception));
            }
        }
        return null;
    }

    private static void buildSchema(ExcelDataSource excelDataSource, Range range, Sheet sheet, SchemaBuilder schemaBuilder) {
        Cell[] cellArray = null;
        int n = excelDataSource.getHeaderRow();
        for (int i = 0; i < n - 1; ++i) {
            ++range.top;
        }
        if (n > 0) {
            cellArray = sheet.getRow(range.top++);
        }
        Cell[] cellArray2 = sheet.getRow(range.top);
        int n2 = range.right - range.left + 1;
        for (int i = 0; i < n2; ++i) {
            Cell cell = cellArray != null ? cellArray[range.left + i] : null;
            Object object = cell != null ? cell.getValueString() : "Field" + (i + 1);
            Cell cell2 = cellArray2[range.left + i];
            DataType dataType = XInferSchema.determineType(cell2);
            schemaBuilder.add((String)object, dataType, new DataAttributes());
        }
    }

    private static DataType determineType(Cell cell) {
        DataType dataType = DataType.STRING;
        if (cell != null) {
            int n = cell.getType();
            if (1 == n) {
                dataType = DataType.STRING;
            } else if (6 == n) {
                dataType = DataType.BOOLEAN;
            } else if (2 == n) {
                dataType = DataType.DATE;
            } else if (3 == n) {
                dataType = DataType.TIME;
            } else if (4 == n) {
                dataType = DataType.TIMESTAMP;
            } else if (5 == n) {
                dataType = DataType.DOUBLE;
            }
        }
        return dataType;
    }
}

