/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.filter;

import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.filter.Filter;
import com.elixirtech.util.BitSetIterator;
import java.util.BitSet;
import javax.print.attribute.SetOfIntegerSyntax;

public class SelectionFilter
implements Filter {
    public static final String TYPE = "Selection";
    public static final String KEEP = "Keep";
    public static final String DISCARD = "Discard";
    protected BitSet m_Rows;
    protected int m_CurrentIndex;
    protected boolean m_Discard;

    public static BitSet build(int[] nArray) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < nArray.length; ++i) {
            bitSet.set(nArray[i]);
        }
        return bitSet;
    }

    public SelectionFilter(String string, String string2) {
        this.m_Discard = DISCARD.equals(string);
        this.m_Rows = new BitSet();
        IntSet intSet = new IntSet(string2);
        int[][] nArray = intSet.getMembers();
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            for (int j = nArray2[0]; j <= nArray2[1]; ++j) {
                this.m_Rows.set(j);
            }
        }
    }

    public SelectionFilter(String string, BitSet bitSet) {
        this.m_Discard = DISCARD.equals(string);
        this.m_Rows = bitSet;
    }

    public BitSet getRows() {
        return this.m_Rows;
    }

    public void setRows(BitSet bitSet) {
        this.m_Rows = bitSet;
    }

    public String getRowsString() {
        StringBuilder stringBuilder = new StringBuilder();
        BitSetIterator bitSetIterator = new BitSetIterator(this.m_Rows);
        while (bitSetIterator.hasNext()) {
            stringBuilder.append(bitSetIterator.next());
            if (!bitSetIterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return this.m_Discard ? DISCARD : KEEP;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getValue() {
        return this.getRowsString();
    }

    @Override
    public void buildParameters(ArgumentMap argumentMap) {
    }

    @Override
    public void setSchema(PushContext pushContext, DataSchema dataSchema) {
        this.m_CurrentIndex = 0;
    }

    @Override
    public boolean accept(DataRecord dataRecord) {
        boolean bl = this.m_Rows.get(this.m_CurrentIndex);
        ++this.m_CurrentIndex;
        return this.m_Discard ? !bl : bl;
    }

    protected static class IntSet
    extends SetOfIntegerSyntax {
        public IntSet(String string) {
            super(string);
        }
    }
}

