/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.jdbc;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.jdbc.JDBCConnector;
import com.elixirtech.data2.datasource.jdbc.JDBCDataSource;
import com.elixirtech.data2.datasource.jdbc.PreparedStatementBuilder;
import com.elixirtech.data2.datasource.jdbc.PreparedStatementInfo;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import scala.Option;

class JDBCProcessor {
    private static boolean warnedNoVersion = false;
    private static boolean warnedNoReadOnly = false;
    private static boolean warnedAutoCommit = false;
    protected final JDBCDataSource m_Source;
    protected Connection m_Connection;
    protected Statement m_Statement;
    protected ResultSet m_ResultSet;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(JDBCProcessor.class);

    public JDBCProcessor(JDBCDataSource jDBCDataSource) {
        this.m_Source = jDBCDataSource;
    }

    public Connection connect(PushContext pushContext) {
        JDBCConnector.Pool pool = this.m_Source.getConnector();
        try {
            block11: {
                block10: {
                    block9: {
                        this.m_Connection = ((JDBCConnector)pool).getConnection(pushContext);
                        try {
                            DatabaseMetaData databaseMetaData = this.m_Connection.getMetaData();
                            int n = databaseMetaData.getJDBCMajorVersion();
                            int n2 = databaseMetaData.getJDBCMinorVersion();
                            m_Log.debug((Object)("JDBC Connection obtained. JDBC Version: " + n + "." + n2));
                            if (n < 2) {
                                throw new DataException("JDBC >= 2.0 Required. Got " + n + "." + n2);
                            }
                        }
                        catch (Throwable throwable) {
                            if (warnedNoVersion) break block9;
                            m_Log.warn((Object)"Your database driver doesn't provide JDBC version information.");
                            warnedNoVersion = true;
                        }
                    }
                    try {
                        this.m_Connection.setReadOnly(this.m_Source.isReadOnly());
                    }
                    catch (Throwable throwable) {
                        if (warnedNoReadOnly) break block10;
                        m_Log.warn((Object)"Your database driver doesn't support setReadOnly.");
                        warnedNoReadOnly = true;
                    }
                }
                try {
                    this.m_Connection.setAutoCommit(this.m_Source.isAutoCommit());
                }
                catch (Throwable throwable) {
                    if (warnedAutoCommit) break block11;
                    m_Log.warn((Object)"Your database driver doesn't support setAutoCommit.");
                    warnedAutoCommit = true;
                }
            }
            return this.m_Connection;
        }
        catch (Exception exception) {
            String string = ArgumentMap.substitute(((JDBCConnector)pool).getDescription(), pushContext);
            throw new RuntimeException("Unable to get JDBC connection to " + string, exception);
        }
    }

    public Object executeCallableStatement(PushContext pushContext) throws SQLException {
        String string = this.m_Source.getName();
        m_Log.debug((Object)("Execute callable statement start, " + string));
        List<JDBCDataSource.InParameter> list = this.m_Source.getInParameters();
        this.m_Statement = this.m_Connection.prepareCall(pushContext.substitute(this.m_Source.getSQL()));
        this.applyOptions(pushContext);
        CallableStatement callableStatement = (CallableStatement)this.m_Statement;
        int n = this.m_Source.getOutType();
        if (n != 0) {
            if (n == 2 || n == 3) {
                callableStatement.registerOutParameter(1, this.m_Source.getOutType(), this.m_Source.getOutTypeScale());
            } else {
                callableStatement.registerOutParameter(1, this.m_Source.getOutType());
            }
            this.setInParameters(pushContext, callableStatement, list, 2);
            m_Log.debug((Object)("Execute callable statement, " + string));
            callableStatement.execute();
            m_Log.debug((Object)("Execute callable statement end, " + string));
            return callableStatement.getObject(1);
        }
        this.setInParameters(pushContext, callableStatement, list, 1);
        m_Log.debug((Object)("Execute callable statement query, " + string));
        ResultSet resultSet = callableStatement.executeQuery();
        m_Log.debug((Object)("End execute callable statement query, " + string));
        return resultSet;
    }

    public ResultSet executeStatement(PushContext pushContext) throws SQLException {
        Option<PreparedStatementInfo> option;
        String string = this.m_Source.getSQL().trim();
        if (string.startsWith("{") && (option = PreparedStatementBuilder.build(string)).isDefined()) {
            return this.executePreparedStatement(pushContext, (PreparedStatementInfo)option.get());
        }
        return this.executeSimpleStatement(pushContext);
    }

    public ResultSet executeSimpleStatement(PushContext pushContext) throws SQLException {
        String string = this.m_Source.getName();
        m_Log.debug((Object)("Execute statement start, " + string));
        this.m_Statement = this.m_Connection.createStatement(1003, 1007);
        this.applyOptions(pushContext);
        String string2 = pushContext.substitute(this.m_Source.getSQL());
        m_Log.debug((Object)("Execute sql, " + string2));
        this.m_ResultSet = this.m_Statement.executeQuery(string2);
        return this.m_ResultSet;
    }

    public ResultSet executePreparedStatement(PushContext pushContext, PreparedStatementInfo preparedStatementInfo) throws SQLException {
        String string = this.m_Source.getName();
        m_Log.debug((Object)("Execute prepared statement start, " + string));
        String string2 = pushContext.substitute(preparedStatementInfo.combinedSql());
        PreparedStatement preparedStatement = this.m_Connection.prepareStatement(string2, 1003, 1007);
        this.m_Statement = preparedStatement;
        PreparedStatementBuilder.setArgs(preparedStatement, preparedStatementInfo, pushContext);
        this.applyOptions(pushContext);
        m_Log.debug((Object)("Execute sql, " + string2));
        this.m_ResultSet = preparedStatement.executeQuery();
        return this.m_ResultSet;
    }

    public void close() {
        try {
            if (this.m_ResultSet != null) {
                this.m_ResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.m_ResultSet = null;
        try {
            if (this.m_Statement != null) {
                this.m_Statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.m_Statement = null;
        try {
            if (this.m_Connection != null) {
                this.m_Connection.close();
            }
        }
        catch (SQLException sQLException) {
            m_Log.error((Object)("Unable to close connection, SQLException: " + sQLException.getMessage()), (Throwable)sQLException);
        }
        this.m_Connection = null;
    }

    private void applyOptions(PushContext pushContext) throws SQLException {
        String string;
        String string2;
        String string3 = pushContext.substitute(this.m_Source.getFetchSize());
        if (StringUtil.notEmpty(string3)) {
            try {
                int n = Integer.parseInt(string3);
                this.m_Statement.setFetchSize(n);
            }
            catch (NumberFormatException numberFormatException) {
                m_Log.warn((Object)("Can't parse fetch size: " + string3));
            }
        }
        if (StringUtil.notEmpty(string2 = pushContext.substitute(this.m_Source.getMaxRows()))) {
            try {
                int n = Integer.parseInt(string2);
                this.m_Statement.setMaxRows(n);
            }
            catch (NumberFormatException numberFormatException) {
                m_Log.warn((Object)("Can't parse max rows: " + string2));
            }
        }
        if (StringUtil.notEmpty(string = pushContext.substitute(this.m_Source.getTimeout()))) {
            try {
                int n = Integer.parseInt(string);
                this.m_Statement.setQueryTimeout(n);
            }
            catch (NumberFormatException numberFormatException) {
                m_Log.warn((Object)("Can't parse timeout: " + string3));
            }
        }
    }

    private void setInParameters(PushContext pushContext, CallableStatement callableStatement, List<JDBCDataSource.InParameter> list, int n) {
        int n2 = n;
        for (JDBCDataSource.InParameter inParameter : list) {
            String string = null;
            try {
                string = pushContext.substitute(inParameter.value);
                switch (inParameter.type.getTypeId()) {
                    case 3: {
                        callableStatement.setBoolean(n2, (boolean)Boolean.valueOf(string));
                        break;
                    }
                    case 8: {
                        callableStatement.setLong(n2, Long.parseLong(string));
                        break;
                    }
                    case 6: {
                        callableStatement.setDouble(n2, (double)Double.valueOf(string));
                        break;
                    }
                    case 2: {
                        callableStatement.setString(n2, string);
                        break;
                    }
                    case 4: {
                        callableStatement.setDate(n2, Date.valueOf(string));
                        break;
                    }
                    case 12: {
                        callableStatement.setTime(n2, Time.valueOf(string));
                        break;
                    }
                    case 13: {
                        callableStatement.setTimestamp(n2, Timestamp.valueOf(string));
                        break;
                    }
                    default: {
                        m_Log.warn((Object)("DataType " + inParameter.type.getTypeName() + " not supported as a JDBC in parameter"));
                        break;
                    }
                }
            }
            catch (SQLException sQLException) {
                m_Log.error((Object)("Error setting JDBC in parameter " + inParameter.type.getTypeName() + " with " + string + " : " + sQLException));
            }
            ++n2;
        }
    }
}

