/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.parameters;

import com.elixirtech.data2.AbstractDataSource;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;

public class ParameterSupplier
extends AbstractDataSource {
    private String m_Name;
    private String m_Description;
    private IDataSource m_Parent;
    private IDataSource m_Parameters;
    private boolean m_Iterate;

    public void setName(String string) {
        this.m_Name = string;
    }

    public void setDescription(String string) {
        this.m_Description = string;
    }

    public void setParentDataSource(IDataSource iDataSource) {
        this.m_Parent = iDataSource;
    }

    public void setParametersDataSource(IDataSource iDataSource) {
        this.m_Parameters = iDataSource;
    }

    public IDataSource getParentDataSource() {
        return this.m_Parent;
    }

    public IDataSource getParametersDataSource() {
        return this.m_Parameters;
    }

    public void setIterate(boolean bl) {
        this.m_Iterate = bl;
    }

    public boolean isIterate() {
        return this.m_Iterate;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    @Override
    public String getType() {
        return "ParameterSupplier";
    }

    @Override
    public DataSchema getSchema() {
        if (this.m_Parent != null) {
            return this.m_Parent.getSchema();
        }
        return null;
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        if (this.m_Parameters != null) {
            DL dL = new DL(dataListener);
            DataTable dataTable = DataTable.build(pushContext, this.m_Parameters);
            DataSchema dataSchema = dataTable.getSchema();
            int n = dataSchema.getColumnCount();
            dataListener.startData(this);
            DataRecord[] dataRecordArray = dataTable.getRecords();
            for (int i = 0; i < dataRecordArray.length; ++i) {
                Object[] objectArray = dataRecordArray[i].getData();
                if (!(pushContext instanceof DefaultPushContext)) continue;
                DefaultPushContext defaultPushContext = (DefaultPushContext)pushContext;
                for (int j = 0; j < n; ++j) {
                    String string = dataSchema.getColumnName(j);
                    String string2 = dataSchema.format(dataSchema.getColumnType(j), objectArray[j]);
                    defaultPushContext.setParameter(string, string2);
                }
                this.m_Parent.pushTo(pushContext, dL);
                if (dL.isBreak() || !this.m_Iterate) break;
            }
            dataListener.endData(this);
        } else {
            this.m_Parent.pushTo(pushContext, dataListener);
        }
    }

    private class DL
    implements DataListener2 {
        private DataListener m_DataListener;
        private boolean m_Break;

        public DL(DataListener dataListener) {
            this.m_DataListener = dataListener;
        }

        @Override
        public void startData(IDataSource iDataSource) {
        }

        @Override
        public void startGroup(DataGroup dataGroup) {
            this.m_DataListener.startGroup(dataGroup);
        }

        @Override
        public boolean processRecord(DataRecord dataRecord) {
            boolean bl = this.m_DataListener.processRecord(dataRecord);
            if (!bl) {
                this.m_Break = true;
            }
            return bl;
        }

        @Override
        public void endGroup(DataGroup dataGroup) {
            this.m_DataListener.endGroup(dataGroup);
        }

        @Override
        public void endData(IDataSource iDataSource) {
        }

        @Override
        public <T> T getAdapter(Class<T> clazz) {
            if (clazz == IDataSource.class) {
                return clazz.cast(ParameterSupplier.this);
            }
            return null;
        }

        public boolean isBreak() {
            return this.m_Break;
        }
    }
}

