/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.datasource.processor.IProcessor;
import com.elixirtech.data2.datasource.processor.attributes.AttributesProcessor;
import com.elixirtech.data2.datasource.processor.debug.DebugProcessor;
import com.elixirtech.data2.datasource.processor.invertdata.InvertDataProcessor;
import com.elixirtech.data2.datasource.processor.javascript.JavaScriptProcessor;
import com.elixirtech.data2.datasource.processor.map.MapFieldProcessor;
import com.elixirtech.data2.datasource.processor.remdup.RemoveDuplicatesProcessor;
import com.elixirtech.data2.datasource.processor.sql.SQLProcessor;
import com.elixirtech.data2.datasource.processor.trim.TrimProcessor;
import com.elixirtech.data2.datasource.processor.validation.ValidationProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessorRegistry {
    private static List<Class<? extends IProcessor>> m_Processors = new ArrayList<Class<? extends IProcessor>>();
    private static Map<String, Class<? extends IProcessor>> m_ProcessorMap = new HashMap<String, Class<? extends IProcessor>>();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ProcessorRegistry.class);

    public static void register(String string, Class<? extends IProcessor> clazz) {
        if (clazz != null) {
            m_Processors.add(clazz);
        }
        if (clazz != null) {
            m_ProcessorMap.put(string, clazz);
        }
    }

    public static IProcessor newProcessor(String string) {
        Class<? extends IProcessor> clazz = m_ProcessorMap.get(string);
        if (clazz != null) {
            try {
                return clazz.newInstance();
            }
            catch (Exception exception) {
                m_Log.error((Object)("Can't load processor for \"" + string + "\" : " + clazz.getName() + " : " + exception), (Throwable)exception);
            }
        }
        return null;
    }

    static {
        ProcessorRegistry.register("InvertData", InvertDataProcessor.class);
        ProcessorRegistry.register("RemoveDuplicates", RemoveDuplicatesProcessor.class);
        ProcessorRegistry.register("JavaScript", JavaScriptProcessor.class);
        ProcessorRegistry.register("SQL", SQLProcessor.class);
        ProcessorRegistry.register("Debug", DebugProcessor.class);
        ProcessorRegistry.register("Attributes", AttributesProcessor.class);
        ProcessorRegistry.register("Trim", TrimProcessor.class);
        ProcessorRegistry.register("Validation", ValidationProcessor.class);
        ProcessorRegistry.register(MapFieldProcessor.NAME, MapFieldProcessor.class);
    }
}

