/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.attributes;

import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.SchemaItem;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.jdom.Element;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AttributesNode
extends ProcessorNode {
    private Map<String, DataAttributes> m_Attributes = new HashMap<String, DataAttributes>();

    public AttributesNode() {
    }

    public AttributesNode(Element element) {
        this.loadFrom(element);
    }

    @Override
    public String getProcessorType() {
        return "Attributes";
    }

    @Override
    public DataSchema getSchema(DataSchema dataSchema) {
        SchemaBuilder schemaBuilder = new SchemaBuilder(dataSchema.isCaseSensitive());
        int n = dataSchema.getColumnCount();
        for (int i = 0; i < n; ++i) {
            SchemaItem schemaItem = dataSchema.getColumn(i);
            DataAttributes dataAttributes = this.m_Attributes.get(schemaItem.name);
            if (dataAttributes != null) {
                SchemaItem schemaItem2 = new SchemaItem(schemaItem.name, schemaItem.type, dataAttributes);
                schemaBuilder.add(schemaItem2);
                continue;
            }
            schemaBuilder.add(schemaItem);
        }
        return schemaBuilder.getSchema();
    }

    public void putAttributes(String string, DataAttributes dataAttributes) {
        this.m_Attributes.put(string, dataAttributes);
    }

    @Override
    public void readXMLAnnotations(Element element) {
        this.loadFrom(element);
    }

    @Override
    public void writeXMLAnnotations(Element element) {
        this.saveTo(element);
    }

    public void saveTo(Element element) {
        for (Map.Entry<String, DataAttributes> entry : this.m_Attributes.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            Element element2 = entry.getValue().getElement();
            element2.setAttribute("name", entry.getKey());
            element.addContent(element2);
        }
    }

    public void loadFrom(Element element) {
        this.m_Attributes.clear();
        List<Element> list = element.getChildren("attributes", Data2Constants.NS_DATASOURCE);
        for (Element element2 : list) {
            String string = element2.getAttributeValue("name");
            this.m_Attributes.put(string, new DataAttributes(element2));
        }
    }
}

