/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.javascript;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.datasource.processor.javascript.JavaScriptProcessor;
import com.elixirtech.js.BasicScope;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;

public class JSScope
extends BasicScope {
    private DataSchema m_Schema;
    private final Map<String, Integer> m_Names = new HashMap<String, Integer>();
    private Object[] m_Data;

    public JSScope(JavaScriptProcessor javaScriptProcessor) {
        this.m_Schema = javaScriptProcessor.getInputSchema();
        int n = this.m_Schema.getColumnCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.m_Schema.getColumnName(i);
            if (!StringUtil.notEmpty((String)object)) continue;
            char c = ((String)object).charAt(0);
            if (!Character.isJavaIdentifierStart(c)) {
                object = "_" + (String)object;
            }
            this.m_Names.put((String)object, new Integer(i));
        }
    }

    public void setData(Object[] objectArray) {
        this.m_Data = objectArray;
    }

    @Override
    public String getClassName() {
        return "JSScope";
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        if (this.m_Names.containsKey(string)) {
            return true;
        }
        return super.has(string, scriptable);
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        if (this.m_Data != null) {
            Integer n = this.m_Names.get(string);
            if (n == null) {
                return super.get(string, scriptable);
            }
            Object object = this.m_Data[n];
            if (object instanceof Character) {
                object = String.valueOf(((Character)object).charValue());
            }
            return object;
        }
        return super.get(string, scriptable);
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        Object object2 = object;
        if (this.m_Data != null) {
            Integer n = this.m_Names.get(string);
            if (n == null) {
                super.put(string, scriptable, object2);
            } else {
                int n2 = n;
                if (object2 instanceof NativeJavaObject) {
                    object2 = ((NativeJavaObject)object2).unwrap();
                }
                this.m_Data[n2] = object2;
            }
        } else {
            super.put(string, scriptable, object2);
        }
    }
}

