/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.javascript;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.RelCol;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.ensemble.canvas.SchemaNode;

public class JavaScriptNode
extends ProcessorNode {
    public static final String START_DATA = "startData";
    public static final String START_GROUP = "startGroup";
    public static final String PROCESS_RECORD = "processRecord";
    public static final String END_GROUP = "endGroup";
    public static final String END_DATA = "endData";
    private DataSchema m_CachedSchema;

    public String getStartData() {
        return this.getUserProperty(START_DATA);
    }

    public void setStartData(String string) {
        this.setUserProperty(START_DATA, string);
    }

    public String getStartGroup() {
        return this.getUserProperty(START_GROUP);
    }

    public void setStartGroup(String string) {
        this.setUserProperty(START_GROUP, string);
    }

    public String getProcessRecord() {
        return this.getUserProperty(PROCESS_RECORD);
    }

    public void setProcessRecord(String string) {
        this.setUserProperty(PROCESS_RECORD, string);
    }

    public String getEndGroup() {
        return this.getUserProperty(END_GROUP);
    }

    public void setEndGroup(String string) {
        this.setUserProperty(END_GROUP, string);
    }

    public String getEndData() {
        return this.getUserProperty(END_DATA);
    }

    public void setEndData(String string) {
        this.setUserProperty(END_DATA, string);
    }

    @Override
    public String getProcessorType() {
        return "JavaScript";
    }

    @Override
    public DataSchema getSchema(DataSchema dataSchema) {
        return this.getSchema();
    }

    public DataSchema getSchema() {
        if (this.m_CachedSchema == null) {
            this.extractCachedSchema();
        }
        return this.m_CachedSchema;
    }

    public void setSchema(DataSchema dataSchema) {
        SchemaNode schemaNode = (SchemaNode)this.getNode(SchemaNode.class);
        if (schemaNode != null) {
            schemaNode.disconnect();
        }
        if (dataSchema != null) {
            schemaNode = new SchemaNode(dataSchema);
            this.connectTo(schemaNode, RelType.Owns);
        }
        this.m_CachedSchema = dataSchema;
    }

    private void extractCachedSchema() {
        SchemaNode schemaNode = (SchemaNode)this.getNode(SchemaNode.class);
        if (schemaNode != null) {
            this.m_CachedSchema = schemaNode.getSchema();
        }
    }

    private Node getNode(Class<?> clazz) {
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        for (Node node : relCol.getTargetElements()) {
            if (!node.getClass().equals(clazz)) continue;
            return node;
        }
        return null;
    }
}

