/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.remdup;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IAdaptable;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.datasource.composite.DataStoreRegistry;
import com.elixirtech.data2.datasource.processor.BasicProcessor;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.data2.datasource.processor.remdup.DuplicateNode;
import com.elixirtech.data2.datasource.processor.remdup.RecordComparator;
import com.elixirtech.data2.output.IDataStore;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Element;
import com.elixirtech.util.BitSetIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RemoveDuplicatesProcessor
extends BasicProcessor {
    private DuplicateNode m_Node;
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RemoveDuplicatesProcessor.class);

    @Override
    public String getName() {
        return "RemoveDuplicates";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getType() {
        return "RemoveDuplicates";
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        if (this.m_Node.isInputSorted()) {
            this.m_Parent.pushTo(pushContext, new SortedDL2(pushContext, dataListener));
        } else {
            this.m_Parent.pushTo(pushContext, new UnsortedDL2(pushContext, dataListener));
        }
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IAdaptable.class) {
            return clazz.cast(this);
        }
        if (clazz == IDataSource.class) {
            return clazz.cast(this);
        }
        return null;
    }

    @Override
    public void loadFrom(Element element) throws IOException {
        Object object;
        String string = element.getAttributeValue("type");
        if (!this.getType().equals(string)) {
            throw new IOException("Type " + this.getType() + " expected. Got " + string);
        }
        Element element2 = element.getChild("remove-duplicates", Data2Constants.NS_DATASOURCE);
        boolean bl = "Yes".equals(element2.getAttributeValue("input-sorted"));
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = element2.getChildren("test", Data2Constants.NS_DATASOURCE);
        for (Element object22 : stringArray) {
            object = object22.getAttributeValue("name");
            if (!StringUtil.notEmpty((String)object)) continue;
            arrayList.add((String)object);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        this.m_Node = new DuplicateNode(bl, stringArray);
        List<Element> list = element2.getChildren("property", Data2Constants.NS_DATASOURCE);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Element)iterator.next();
            String string2 = ((Element)object).getAttributeValue("key");
            String string3 = ((Element)object).getText();
            this.m_Node.setUserProperty(string2, string3);
        }
    }

    @Override
    public void saveTo(Element element) {
        element.setAttribute("type", this.getType());
        Element element2 = new Element("remove-duplicates", Data2Constants.NS_DATASOURCE);
        if (this.m_Node != null) {
            Object object;
            element2.setAttribute("input-sorted", this.m_Node.isInputSorted() ? "Yes" : "No");
            String[] stringArray = this.m_Node.getTests();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!StringUtil.notEmpty(stringArray[i])) continue;
                object = new Element("field", Data2Constants.NS_DATASOURCE);
                ((Element)object).setAttribute("name", stringArray[i]);
                element2.addContent((Content)object);
            }
            Map<String, String> map = this.m_Node.getUserProperties();
            object = map.entrySet();
            Iterator<Map.Entry<String, String>> iterator = object.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String string = entry.getKey();
                String string2 = entry.getValue();
                Element element3 = new Element("property", Data2Constants.NS_DATASOURCE);
                element3.setAttribute("key", string);
                element3.setText(string2);
                element2.addContent(element3);
            }
        }
        element.addContent(element2);
    }

    @Override
    public void setProcessorNode(ProcessorNode processorNode) {
        this.m_Node = (DuplicateNode)processorNode;
    }

    @Override
    public ProcessorNode getProcessorNode() {
        return this.m_Node;
    }

    private class SortedDL2
    extends BasicDL2 {
        private DataRecord m_LastRecord;
        private Comparator<DataRecord> m_Comparator;

        public SortedDL2(PushContext pushContext, DataListener dataListener) {
            super(pushContext, dataListener);
        }

        @Override
        public void startData(IDataSource iDataSource) {
            this.buildComparator(iDataSource);
            super.startData(iDataSource);
        }

        @Override
        public boolean processRecord(DataRecord dataRecord) {
            if (this.m_LastRecord != null && this.m_Comparator.compare(this.m_LastRecord, dataRecord) == 0) {
                this.discard(dataRecord);
                return true;
            }
            boolean bl = this.m_DataListener.processRecord(dataRecord);
            this.m_LastRecord = dataRecord;
            return bl;
        }

        private void buildComparator(IDataSource iDataSource) {
            DataSchema dataSchema = iDataSource.getSchema();
            String[] stringArray = RemoveDuplicatesProcessor.this.m_Node.getTests();
            BitSet bitSet = new BitSet();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!StringUtil.notEmpty(stringArray[i])) continue;
                int n = dataSchema.getColumnIndex(stringArray[i]);
                if (n < 0) {
                    m_Log.warn((Object)("Test Column not found: " + stringArray[i]));
                    continue;
                }
                bitSet.set(n);
            }
            this.m_Comparator = new RecordComparator(bitSet);
        }
    }

    private class UnsortedDL2
    extends BasicDL2 {
        private Set<RecordWrapper> m_Records;
        private BitSet m_Bits;

        public UnsortedDL2(PushContext pushContext, DataListener dataListener) {
            super(pushContext, dataListener);
        }

        @Override
        public void startData(IDataSource iDataSource) {
            this.buildBits(iDataSource);
            this.m_Records = new HashSet<RecordWrapper>();
            super.startData(iDataSource);
        }

        @Override
        public boolean processRecord(DataRecord dataRecord) {
            RecordWrapper recordWrapper = new RecordWrapper(dataRecord, this.m_Bits);
            if (this.m_Records.contains(recordWrapper)) {
                this.discard(dataRecord);
                return true;
            }
            this.m_Records.add(recordWrapper);
            boolean bl = this.m_DataListener.processRecord(dataRecord);
            return bl;
        }

        private void buildBits(IDataSource iDataSource) {
            DataSchema dataSchema = iDataSource.getSchema();
            String[] stringArray = RemoveDuplicatesProcessor.this.m_Node.getTests();
            this.m_Bits = new BitSet();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!StringUtil.notEmpty(stringArray[i])) continue;
                int n = dataSchema.getColumnIndex(stringArray[i]);
                if (n < 0) {
                    m_Log.warn((Object)("Test Column not found: " + stringArray[i]));
                    continue;
                }
                this.m_Bits.set(n);
            }
        }
    }

    private static class RecordWrapper {
        private DataRecord m_Record;
        private BitSet m_Bits;

        public RecordWrapper(DataRecord dataRecord, BitSet bitSet) {
            this.m_Record = dataRecord;
            this.m_Bits = bitSet;
        }

        public boolean equals(Object object) {
            if (this.m_Bits.isEmpty()) {
                return this.m_Record.equals(object);
            }
            if (object instanceof RecordWrapper) {
                RecordWrapper recordWrapper = (RecordWrapper)object;
                BitSetIterator bitSetIterator = new BitSetIterator(this.m_Bits);
                while (bitSetIterator.hasNext()) {
                    int n = bitSetIterator.next();
                    if (this.equal(this.m_Record.getData(n), recordWrapper.m_Record.getData(n))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            if (this.m_Bits.isEmpty()) {
                return this.m_Record.hashCode();
            }
            int n = 0;
            BitSetIterator bitSetIterator = new BitSetIterator(this.m_Bits);
            while (bitSetIterator.hasNext()) {
                n <<= 1;
                Object object = this.m_Record.getData(bitSetIterator.next());
                if (object == null) continue;
                n |= object.hashCode();
            }
            return n;
        }

        private boolean equal(Object object, Object object2) {
            if (object == null) {
                return object2 == null;
            }
            return object.equals(object2);
        }
    }

    private abstract class BasicDL2
    implements DataListener2 {
        protected PushContext m_Context;
        protected DataListener m_DataListener;
        protected DataListener m_DiscardListener;

        public BasicDL2(PushContext pushContext, DataListener dataListener) {
            this.m_Context = pushContext;
            this.m_DataListener = dataListener;
        }

        @Override
        public <T> T getAdapter(Class<T> clazz) {
            if (clazz == IAdaptable.class) {
                return clazz.cast(this);
            }
            if (clazz == IDataSource.class) {
                return clazz.cast(RemoveDuplicatesProcessor.this.getOwner());
            }
            return null;
        }

        @Override
        public void startData(IDataSource iDataSource) {
            String string = RemoveDuplicatesProcessor.this.m_Node.getUserProperty("DataStore_Type");
            if (StringUtil.notEmpty(string) && !"None".equals(string)) {
                DataStore dataStore = DataStoreRegistry.buildDataStore(RemoveDuplicatesProcessor.this.m_Node);
                this.m_DiscardListener = DataStoreRegistry.getDataListener(this.m_Context, dataStore);
                if (this.m_DiscardListener instanceof IDataStore) {
                    IDataStore iDataStore = (IDataStore)this.m_DiscardListener;
                    iDataStore.setContext(this.m_Context);
                    iDataStore.setName(RemoveDuplicatesProcessor.this.getName());
                }
            }
            this.m_DataListener.startData(RemoveDuplicatesProcessor.this);
            if (this.m_DiscardListener != null) {
                this.m_DiscardListener.startData(RemoveDuplicatesProcessor.this);
            }
        }

        @Override
        public void startGroup(DataGroup dataGroup) {
            this.m_DataListener.startGroup(dataGroup);
        }

        @Override
        public void endGroup(DataGroup dataGroup) {
            this.m_DataListener.endGroup(dataGroup);
        }

        @Override
        public void endData(IDataSource iDataSource) {
            this.m_DataListener.endData(RemoveDuplicatesProcessor.this);
            if (this.m_DiscardListener != null) {
                this.m_DiscardListener.endData(RemoveDuplicatesProcessor.this);
            }
        }

        protected void discard(DataRecord dataRecord) {
            if (this.m_DiscardListener != null) {
                this.m_DiscardListener.processRecord(dataRecord);
            }
        }
    }
}

