/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.validation;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.attributes.Enumeration;
import com.elixirtech.data2.attributes.Nullable;
import com.elixirtech.data2.attributes.Range;
import com.elixirtech.data2.attributes.RegExp;
import com.elixirtech.data2.datasource.processor.validation.EnumerationValidator;
import com.elixirtech.data2.datasource.processor.validation.GenericRegExpValidator;
import com.elixirtech.data2.datasource.processor.validation.IValidator;
import com.elixirtech.data2.datasource.processor.validation.NotNullValidator;
import com.elixirtech.data2.datasource.processor.validation.RangeValidator;
import com.elixirtech.data2.datasource.processor.validation.StringRegExpValidator;
import com.elixirtech.data2.datasource.processor.validation.ValidationNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.PatternSyntaxException;

public class Validator {
    private List<IValidator> m_Steps;
    private DataSchema m_Schema;
    private int m_SourceLength;
    private int m_SchemaLength;
    private int m_CountIdx;
    private int m_MessagesIdx;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Validator.class);

    public static Validator build(IDataSource iDataSource) {
        DataSchema dataSchema = iDataSource.getSchema();
        ArrayList<IValidator> arrayList = new ArrayList<IValidator>();
        int n = dataSchema.getColumnCount();
        for (int i = 0; i < n; ++i) {
            for (DataAttribute dataAttribute : dataSchema.getAttributes(i).getAttributes()) {
                Validator.buildValidator(arrayList, dataAttribute, i, dataSchema);
            }
        }
        return new Validator(dataSchema, arrayList);
    }

    private static void buildValidator(List<IValidator> list, DataAttribute dataAttribute, int n, DataSchema dataSchema) {
        block18: {
            String string = dataSchema.getColumnName(n);
            String string2 = dataAttribute.getName();
            if ("Nullable".equals(string2)) {
                if (!((Nullable)dataAttribute).isNullable()) {
                    list.add(new NotNullValidator(n, string));
                }
            } else if ("RegExp".equals(string2)) {
                String string3 = ((RegExp)dataAttribute).getExpression();
                DataType dataType = dataSchema.getColumnType(n);
                try {
                    if (dataType == DataType.STRING) {
                        list.add(new StringRegExpValidator(n, string, string3));
                        break block18;
                    }
                    list.add(new GenericRegExpValidator(n, string, string3, dataType));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    m_Log.error((Object)("Unable to compile regexp \"" + string3 + "\": "), (Throwable)patternSyntaxException);
                }
            } else if ("Range".equals(string2)) {
                DataType dataType = dataSchema.getColumnType(n);
                Range range = (Range)dataAttribute;
                try {
                    Comparable comparable = (Comparable)dataSchema.parse(dataType, range.getStart());
                    Comparable comparable2 = (Comparable)dataSchema.parse(dataType, range.getStop());
                    list.add(new RangeValidator(n, string, comparable, comparable2));
                }
                catch (RuntimeException runtimeException) {
                    m_Log.error((Object)("Unable to parse range as " + dataType.getTypeName() + ": " + runtimeException));
                }
            } else if ("Enumeration".equals(string2)) {
                DataType dataType = dataSchema.getColumnType(n);
                List<String> list2 = ((Enumeration)dataAttribute).getChoices();
                if (dataType == DataType.STRING) {
                    HashSet<Object> hashSet = new HashSet<Object>(list2);
                    list.add(new EnumerationValidator(n, string, hashSet));
                } else {
                    HashSet<Object> hashSet = new HashSet<Object>(list2.size());
                    for (String string4 : list2) {
                        try {
                            hashSet.add(dataSchema.parse(dataType, string4));
                        }
                        catch (RuntimeException runtimeException) {
                            m_Log.warn((Object)("Ignoring enumeration - can't parse " + string4 + " as " + dataType.getTypeName()));
                            return;
                        }
                    }
                    list.add(new EnumerationValidator(n, string, hashSet));
                }
            }
        }
    }

    public Validator(DataSchema dataSchema, List<IValidator> list) {
        this.m_Steps = list;
        ValidationNode validationNode = new ValidationNode();
        this.m_SourceLength = dataSchema.getColumnCount();
        this.m_Schema = validationNode.getSchema(dataSchema);
        this.m_SchemaLength = this.m_Schema.getColumnCount();
        this.m_CountIdx = this.m_Schema.getColumnIndex("elx.validation.FailCount");
        if (this.m_CountIdx < 0) {
            throw new IllegalStateException("No Fail Count");
        }
        this.m_MessagesIdx = this.m_Schema.getColumnIndex("elx.validation.FailMessages");
        if (this.m_MessagesIdx < 0) {
            throw new IllegalStateException("No Fail Messages");
        }
    }

    public DataRecord validate(DataRecord dataRecord) {
        Object[] objectArray = new Object[this.m_SchemaLength];
        System.arraycopy(dataRecord.getData(), 0, objectArray, 0, this.m_SourceLength);
        if (objectArray[this.m_CountIdx] == null) {
            objectArray[this.m_CountIdx] = 0L;
        }
        if (objectArray[this.m_MessagesIdx] == null) {
            objectArray[this.m_MessagesIdx] = "";
        }
        DataRecord dataRecord2 = new DataRecord(this.m_Schema, objectArray);
        for (IValidator iValidator : this.m_Steps) {
            iValidator.validate(this, dataRecord2);
        }
        return dataRecord2;
    }

    protected void addError(String string, DataRecord dataRecord) {
        Object[] objectArray = dataRecord.getData();
        objectArray[this.m_CountIdx] = (Long)objectArray[this.m_CountIdx] + 1L;
        objectArray[this.m_MessagesIdx] = objectArray[this.m_MessagesIdx] == "" ? string : objectArray[this.m_MessagesIdx] + "," + string;
    }
}

