/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.text;

import com.elixirtech.arch.ARM$;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.FileBasedDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.text.AuthHelper$;
import com.elixirtech.data2.datasource.text.TextDataDefinition;
import com.elixirtech.data2.datasource.text.TextDataIterator;
import com.elixirtech.data2.datasource.text.TextDataSource$;
import com.elixirtech.data2.datasource.text.TextDataSource$Spec$;
import com.elixirtech.data2.iterator.IDataRecordIterable;
import com.elixirtech.data2.iterator.IDataRecordIterator;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.List;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public class TextDataSource
extends FileBasedDataSource
implements IDataRecordIterable {
    private final DataSchema schema;
    private final Spec spec;
    private final String AuthNone;
    private final String AuthBasic;
    private final String AuthDigest;

    public static InputStream wrap(InputStream inputStream) {
        return TextDataSource$.MODULE$.wrap(inputStream);
    }

    public TextDataSource(DataSchema schema, Spec spec) {
        this.schema = schema;
        this.spec = spec;
        this.AuthNone = "None";
        this.AuthBasic = "Basic";
        this.AuthDigest = "Digest";
    }

    public DataSchema schema() {
        return this.schema;
    }

    public Spec spec() {
        return this.spec;
    }

    public String AuthNone() {
        return this.AuthNone;
    }

    public String AuthBasic() {
        return this.AuthBasic;
    }

    public String AuthDigest() {
        return this.AuthDigest;
    }

    @Override
    public String getType() {
        return "Text";
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap map = new ArgumentMap();
        map.extractParameters(this.spec().url());
        map.extractParameters(this.spec().authUser());
        map.extractParameters(this.spec().authPassword());
        this.spec().dataDef().extractParameters(map);
        return map.getParameters();
    }

    @Override
    public String getName() {
        return this.spec().name();
    }

    @Override
    public DataSchema getSchema() {
        return this.schema();
    }

    @Override
    public String getDescription() {
        return this.spec().description();
    }

    @Override
    public IDataRecordIterator iterator(Map<String, String> params) {
        return new TextDataIterator(this, params);
    }

    @Override
    public void pushTo(PushContext cxt, DataListener dl) {
        InputStream is = AuthHelper$.MODULE$.getInputStream(cxt, this.spec().url(), this.spec().authMode(), this.spec().authUser(), this.spec().authPassword());
        InputStream wrapper = TextDataSource$.MODULE$.wrap(is);
        BufferedReader br = new BufferedReader(new InputStreamReader(wrapper, this.spec().encoding()));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.spec().skipLines()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)_$1 -> this.spec().dataDef().skipLine(br));
        if (this.spec().firstLineHeader()) {
            this.spec().dataDef().skipLine(br);
        }
        this.spec().dataDef().startParsing(cxt, this);
        dl.startData(this);
        boolean bl = true;
        try {
            while (bl) {
                Option option = Option$.MODULE$.apply((Object)this.spec().dataDef().readLine(br));
                if (option instanceof Some) {
                    String line = (String)((Some)option).value();
                    DataRecord record = new DataRecord(this.schema(), new Object[this.schema().getColumnCount()]);
                    if (!this.spec().dataDef().parseLine(line, record)) continue;
                    bl = dl.processRecord(record);
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    bl = false;
                    continue;
                }
                throw new MatchError((Object)option);
            }
        }
        finally {
            dl.endData(this);
            this.spec().dataDef().endParsing();
        }
    }

    public DataSchema inferSchema(PushContext cxt) {
        ObjectRef optHeader = ObjectRef.create((Object)None$.MODULE$);
        return (DataSchema)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
            InputStream is = (InputStream)arm.manage((Object)TextDataSource$.MODULE$.wrap(AuthHelper$.MODULE$.getInputStream(cxt, this.spec().url(), this.spec().authMode(), this.spec().authUser(), this.spec().authPassword())));
            BufferedReader br = new BufferedReader(new InputStreamReader(is, this.spec().encoding()));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.spec().skipLines()).foreach((Function1 & Serializable)_$2 -> this.inferSchema$$anonfun$1$$anonfun$1(br, BoxesRunTime.unboxToInt((Object)_$2)));
            if (this.spec().firstLineHeader()) {
                Some some = Some$.MODULE$.apply((Object)this.stripBom(this.spec().dataDef().readLine(br)));
                optHeader$1.elem = some;
                some = null;
            }
            Option line = Option$.MODULE$.apply((Object)this.spec().dataDef().readLine(br));
            return this.spec().dataDef().inferSchema((Option<String>)((Option)optHeader$1.elem), (Option<String>)line, this.schema());
        });
    }

    private String stripBom(String s) {
        String string = this.spec().encoding();
        String string2 = "UTF-8";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (s != null && s.length() > 0 && s.charAt(0) == '\ufeff') {
                return s.substring(1);
            }
        }
        return s;
    }

    private final /* synthetic */ String inferSchema$$anonfun$1$$anonfun$1(BufferedReader br$2, int _$2) {
        return this.spec().dataDef().readLine(br$2);
    }

    public static final class Spec
    implements Product,
    Serializable {
        private final String name;
        private final String description;
        private final String url;
        private final String authMode;
        private final String authUser;
        private final String authPassword;
        private final String encoding;
        private final int skipLines;
        private final boolean firstLineHeader;
        private final TextDataDefinition dataDef;

        public static Spec apply(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, boolean bl, TextDataDefinition textDataDefinition) {
            return TextDataSource$Spec$.MODULE$.apply(string, string2, string3, string4, string5, string6, string7, n, bl, textDataDefinition);
        }

        public static Spec fromProduct(Product product) {
            return TextDataSource$Spec$.MODULE$.fromProduct(product);
        }

        public static Spec unapply(Spec spec) {
            return TextDataSource$Spec$.MODULE$.unapply(spec);
        }

        public Spec(String name, String description, String url, String authMode, String authUser, String authPassword, String encoding, int skipLines, boolean firstLineHeader, TextDataDefinition dataDef) {
            this.name = name;
            this.description = description;
            this.url = url;
            this.authMode = authMode;
            this.authUser = authUser;
            this.authPassword = authPassword;
            this.encoding = encoding;
            this.skipLines = skipLines;
            this.firstLineHeader = firstLineHeader;
            this.dataDef = dataDef;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.description()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.url()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.authMode()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.authUser()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.authPassword()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.encoding()));
            n = Statics.mix((int)n, (int)this.skipLines());
            n = Statics.mix((int)n, (int)(this.firstLineHeader() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.dataDef()));
            return Statics.finalizeHash((int)n, (int)10);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Spec)) return false;
            Spec spec = (Spec)object;
            if (this.skipLines() != spec.skipLines()) return false;
            if (this.firstLineHeader() != spec.firstLineHeader()) return false;
            String string = this.name();
            String string2 = spec.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.description();
            String string4 = spec.description();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.url();
            String string6 = spec.url();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.authMode();
            String string8 = spec.authMode();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.authUser();
            String string10 = spec.authUser();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            String string11 = this.authPassword();
            String string12 = spec.authPassword();
            if (string11 == null) {
                if (string12 != null) {
                    return false;
                }
            } else if (!string11.equals(string12)) return false;
            String string13 = this.encoding();
            String string14 = spec.encoding();
            if (string13 == null) {
                if (string14 != null) {
                    return false;
                }
            } else if (!string13.equals(string14)) return false;
            TextDataDefinition textDataDefinition = this.dataDef();
            TextDataDefinition textDataDefinition2 = spec.dataDef();
            if (textDataDefinition == null) {
                if (textDataDefinition2 == null) return true;
                return false;
            } else {
                if (!textDataDefinition.equals(textDataDefinition2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Spec;
        }

        public int productArity() {
            return 10;
        }

        public String productPrefix() {
            return "Spec";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return BoxesRunTime.boxToInteger((int)this._8());
                }
                case 8: {
                    return BoxesRunTime.boxToBoolean((boolean)this._9());
                }
                case 9: {
                    return this._10();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "description";
                }
                case 2: {
                    return "url";
                }
                case 3: {
                    return "authMode";
                }
                case 4: {
                    return "authUser";
                }
                case 5: {
                    return "authPassword";
                }
                case 6: {
                    return "encoding";
                }
                case 7: {
                    return "skipLines";
                }
                case 8: {
                    return "firstLineHeader";
                }
                case 9: {
                    return "dataDef";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }

        public String url() {
            return this.url;
        }

        public String authMode() {
            return this.authMode;
        }

        public String authUser() {
            return this.authUser;
        }

        public String authPassword() {
            return this.authPassword;
        }

        public String encoding() {
            return this.encoding;
        }

        public int skipLines() {
            return this.skipLines;
        }

        public boolean firstLineHeader() {
            return this.firstLineHeader;
        }

        public TextDataDefinition dataDef() {
            return this.dataDef;
        }

        public Spec copy(String name, String description, String url, String authMode, String authUser, String authPassword, String encoding, int skipLines, boolean firstLineHeader, TextDataDefinition dataDef) {
            return new Spec(name, description, url, authMode, authUser, authPassword, encoding, skipLines, firstLineHeader, dataDef);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.description();
        }

        public String copy$default$3() {
            return this.url();
        }

        public String copy$default$4() {
            return this.authMode();
        }

        public String copy$default$5() {
            return this.authUser();
        }

        public String copy$default$6() {
            return this.authPassword();
        }

        public String copy$default$7() {
            return this.encoding();
        }

        public int copy$default$8() {
            return this.skipLines();
        }

        public boolean copy$default$9() {
            return this.firstLineHeader();
        }

        public TextDataDefinition copy$default$10() {
            return this.dataDef();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.description();
        }

        public String _3() {
            return this.url();
        }

        public String _4() {
            return this.authMode();
        }

        public String _5() {
            return this.authUser();
        }

        public String _6() {
            return this.authPassword();
        }

        public String _7() {
            return this.encoding();
        }

        public int _8() {
            return this.skipLines();
        }

        public boolean _9() {
            return this.firstLineHeader();
        }

        public TextDataDefinition _10() {
            return this.dataDef();
        }
    }
}

