/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.text;

import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.text.FixedWidthTextDataDefinition;
import com.elixirtech.data2.datasource.text.RegExpTextDataDefinition;
import com.elixirtech.data2.datasource.text.SeparatedTextDataDefinition;
import com.elixirtech.data2.datasource.text.TextDataDefinition;
import com.elixirtech.data2.datasource.text.TextDataSource;
import com.elixirtech.data2.datasource.text.TextDataSource$Spec$;
import com.elixirtech.data2.datasource.text.TextDefinition$;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Namespace;
import java.io.Serializable;
import scala.Function1;
import scala.Option$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public class TextDefinition
extends DataSourceDefinition {
    public static String AUTH_MODE() {
        return TextDefinition$.MODULE$.AUTH_MODE();
    }

    public static String AUTH_PASSWORD() {
        return TextDefinition$.MODULE$.AUTH_PASSWORD();
    }

    public static String AUTH_USER() {
        return TextDefinition$.MODULE$.AUTH_USER();
    }

    public static String COLUMN() {
        return TextDefinition$.MODULE$.COLUMN();
    }

    public static String DELIMITER() {
        return TextDefinition$.MODULE$.DELIMITER();
    }

    public static String ENCODING() {
        return TextDefinition$.MODULE$.ENCODING();
    }

    public static String PATTERN() {
        return TextDefinition$.MODULE$.PATTERN();
    }

    public static String QUALIFIER() {
        return TextDefinition$.MODULE$.QUALIFIER();
    }

    public static String SKIP_FIRST_ROW() {
        return TextDefinition$.MODULE$.SKIP_FIRST_ROW();
    }

    public static String SKIP_LINES() {
        return TextDefinition$.MODULE$.SKIP_LINES();
    }

    public static String START_PATTERN() {
        return TextDefinition$.MODULE$.START_PATTERN();
    }

    public static String STOP_PATTERN() {
        return TextDefinition$.MODULE$.STOP_PATTERN();
    }

    public static String TEST_MODE() {
        return TextDefinition$.MODULE$.TEST_MODE();
    }

    public static String TYPE_DELIMITED() {
        return TextDefinition$.MODULE$.TYPE_DELIMITED();
    }

    public static String TYPE_FIXED_WIDTH() {
        return TextDefinition$.MODULE$.TYPE_FIXED_WIDTH();
    }

    public static String TYPE_REGEXP() {
        return TextDefinition$.MODULE$.TYPE_REGEXP();
    }

    public static String URL() {
        return TextDefinition$.MODULE$.URL();
    }

    public static String WIDTH() {
        return TextDefinition$.MODULE$.WIDTH();
    }

    public static char getChar(String string) {
        return TextDefinition$.MODULE$.getChar(string);
    }

    public static String normalizeText(char c) {
        return TextDefinition$.MODULE$.normalizeText(c);
    }

    @Override
    public IDataSource getDataSource(DataSourceManager dsm, Element e) {
        TextDataDefinition textDataDefinition;
        block12: {
            block11: {
                if (!"datasource".equals(e.getName())) break block11;
                Namespace namespace = e.getNamespace();
                Namespace namespace2 = Data2Constants.NS_DATASOURCE;
                if (!(namespace == null ? namespace2 != null : !((Object)namespace).equals(namespace2))) break block12;
            }
            throw new IllegalArgumentException("Element " + e.getName() + " is not a ds:datasource");
        }
        String name = e.getAttributeValue("name");
        Element schemaElement = e.getChild("schema", Data2Constants.NS_DATASOURCE);
        if (schemaElement == null) {
            throw new DataException("Can't load schema");
        }
        DataSchema schema = DataSourceDefinition.loadSchema(schemaElement);
        Element text = e.getChild("text", Data2Constants.NS_DATASOURCE);
        if (text == null) {
            throw new DataException("Can't load text element");
        }
        Element delimited = text.getChild(TextDefinition$.MODULE$.TYPE_DELIMITED(), Data2Constants.NS_DATASOURCE);
        Element regexp = text.getChild(TextDefinition$.MODULE$.TYPE_REGEXP(), Data2Constants.NS_DATASOURCE);
        Element fixed = text.getChild(TextDefinition$.MODULE$.TYPE_FIXED_WIDTH(), Data2Constants.NS_DATASOURCE);
        if (delimited != null) {
            char sep = TextDefinition$.MODULE$.getChar(delimited.getAttributeValue(TextDefinition$.MODULE$.DELIMITER()));
            char qualifier = TextDefinition$.MODULE$.getChar(delimited.getAttributeValue(TextDefinition$.MODULE$.QUALIFIER()));
            textDataDefinition = new SeparatedTextDataDefinition(sep, qualifier);
        } else {
            TextDataDefinition textDataDefinition2;
            if (regexp != null) {
                String pattern = regexp.getAttributeValue(TextDefinition$.MODULE$.PATTERN());
                String startPattern = regexp.getAttributeValue(TextDefinition$.MODULE$.START_PATTERN());
                String stopPattern = regexp.getAttributeValue(TextDefinition$.MODULE$.STOP_PATTERN());
                textDataDefinition2 = new RegExpTextDataDefinition(pattern, startPattern, stopPattern);
            } else if (fixed != null) {
                java.util.List<Element> list = fixed.getChildren(TextDefinition$.MODULE$.COLUMN(), Data2Constants.NS_DATASOURCE);
                List widths = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(list).asScala().map((Function1 & Serializable)col -> Integer.parseInt(col.getAttributeValue(TextDefinition$.MODULE$.WIDTH())))).toList();
                textDataDefinition2 = new FixedWidthTextDataDefinition((List<Object>)widths);
            } else {
                throw new DataException("Unknown text definition type");
            }
            textDataDefinition = textDataDefinition2;
        }
        SeparatedTextDataDefinition dataDef = textDataDefinition;
        String description = e.getAttributeValue("description");
        String url = text.getAttributeValue(TextDefinition$.MODULE$.URL());
        String authMode = text.getAttributeValue(TextDefinition$.MODULE$.AUTH_MODE());
        String authUser = (String)Option$.MODULE$.apply((Object)text.getAttributeValue(TextDefinition$.MODULE$.AUTH_USER())).getOrElse(TextDefinition::$anonfun$2);
        String authPassword = (String)Option$.MODULE$.apply((Object)text.getAttributeValue(TextDefinition$.MODULE$.AUTH_PASSWORD())).getOrElse(TextDefinition::$anonfun$3);
        String encoding = text.getAttributeValue(TextDefinition$.MODULE$.ENCODING());
        int skipLines = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply(() -> TextDefinition.$anonfun$4(text)).getOrElse(TextDefinition::$anonfun$5));
        boolean firstHeader = "Yes".equals(text.getAttributeValue(TextDefinition$.MODULE$.SKIP_FIRST_ROW()));
        TextDataSource.Spec spec = TextDataSource$Spec$.MODULE$.apply(name, description, url, authMode, authUser, authPassword, encoding, skipLines, firstHeader, dataDef);
        TextDataSource src = new TextDataSource(schema, spec);
        src.setSecurity(this.loadSecurity(e));
        return src;
    }

    @Override
    public Element setDataSource(IDataSource ids) {
        IDataSource iDataSource = ids;
        if (iDataSource instanceof TextDataSource) {
            TextDataSource src = (TextDataSource)iDataSource;
            return this.setDataSource(src);
        }
        IDataSource other = iDataSource;
        throw new IllegalArgumentException("Not a TextDataSource");
    }

    public Element setDataSource(TextDataSource src) {
        Element datasource = this.defineDataSource(src);
        DataSourceDefinition.saveSchema(src.getSchema(), datasource);
        this.saveSecurity(src.getSecurity(), datasource);
        Element text = new Element("text", Data2Constants.NS_DATASOURCE);
        DataSourceDefinition.setAttribute(text, TextDefinition$.MODULE$.ENCODING(), src.spec().encoding());
        DataSourceDefinition.setAttribute(text, TextDefinition$.MODULE$.SKIP_FIRST_ROW(), src.spec().firstLineHeader());
        DataSourceDefinition.setAttribute(text, TextDefinition$.MODULE$.SKIP_LINES(), src.spec().skipLines());
        DataSourceDefinition.setAttribute(text, TextDefinition$.MODULE$.URL(), src.spec().url());
        DataSourceDefinition.setAttribute(text, TextDefinition$.MODULE$.AUTH_MODE(), src.spec().authMode());
        DataSourceDefinition.setAttribute(text, TextDefinition$.MODULE$.AUTH_USER(), src.spec().authUser());
        DataSourceDefinition.setAttribute(text, TextDefinition$.MODULE$.AUTH_PASSWORD(), src.spec().authPassword());
        TextDataDefinition textDataDefinition = src.spec().dataDef();
        if (textDataDefinition instanceof RegExpTextDataDefinition) {
            RegExpTextDataDefinition redef = (RegExpTextDataDefinition)textDataDefinition;
            Element regexp = new Element(TextDefinition$.MODULE$.TYPE_REGEXP(), Data2Constants.NS_DATASOURCE);
            DataSourceDefinition.setAttribute(regexp, TextDefinition$.MODULE$.PATTERN(), redef.patternString());
            DataSourceDefinition.setAttribute(regexp, TextDefinition$.MODULE$.START_PATTERN(), redef.startPatternString());
            DataSourceDefinition.setAttribute(regexp, TextDefinition$.MODULE$.STOP_PATTERN(), redef.stopPatternString());
            v0 = text.addContent(regexp);
        } else if (textDataDefinition instanceof SeparatedTextDataDefinition) {
            SeparatedTextDataDefinition sdef = (SeparatedTextDataDefinition)textDataDefinition;
            Element delimited = new Element(TextDefinition$.MODULE$.TYPE_DELIMITED(), Data2Constants.NS_DATASOURCE);
            delimited.setAttribute(TextDefinition$.MODULE$.DELIMITER(), TextDefinition$.MODULE$.normalizeText(sdef.sep()));
            delimited.setAttribute(TextDefinition$.MODULE$.QUALIFIER(), TextDefinition$.MODULE$.normalizeText(sdef.qualifier()));
            v0 = text.addContent(delimited);
        } else if (textDataDefinition instanceof FixedWidthTextDataDefinition) {
            FixedWidthTextDataDefinition fdef = (FixedWidthTextDataDefinition)textDataDefinition;
            Element fixed = new Element(TextDefinition$.MODULE$.TYPE_FIXED_WIDTH(), Data2Constants.NS_DATASOURCE);
            List<Object> widths = fdef.getWidths();
            widths.foreach((Function1 & Serializable)w -> TextDefinition.setDataSource$$anonfun$1(fixed, BoxesRunTime.unboxToInt((Object)w)));
            v0 = text.addContent(fixed);
        } else {
            v0 = BoxedUnit.UNIT;
        }
        datasource.addContent(text);
        return datasource;
    }

    private static final String $anonfun$2() {
        return "";
    }

    private static final String $anonfun$3() {
        return "";
    }

    private static final int $anonfun$4(Element text$1) {
        return Integer.parseInt(text$1.getAttributeValue(TextDefinition$.MODULE$.SKIP_LINES()));
    }

    private static final int $anonfun$5() {
        return 0;
    }

    private static final /* synthetic */ Element setDataSource$$anonfun$1(Element fixed$1, int w) {
        Element col = new Element(TextDefinition$.MODULE$.COLUMN(), Data2Constants.NS_DATASOURCE);
        col.setAttribute(TextDefinition$.MODULE$.WIDTH(), Integer.toString(w));
        return fixed$1.addContent(col);
    }
}

