/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.xml;

import com.elixirtech.arch.ElxLoggerJ;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class DocumentCache {
    private static ThreadLocal<Map<String, Document>> m_Map = new ThreadLocal();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DocumentCache.class);

    public static void store(String string) throws Exception {
        m_Log.debug((Object)("Loading document: " + string));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(string);
        Map<String, Document> map = m_Map.get();
        if (map == null) {
            map = new HashMap<String, Document>();
            m_Map.set(map);
        }
        map.put(string, document);
        m_Log.debug((Object)("Loading complete: " + string));
    }

    public static Document lookup(String string) {
        Map<String, Document> map = m_Map.get();
        if (map != null) {
            return map.get(string);
        }
        return null;
    }

    public static void clear(String string) {
        Map<String, Document> map = m_Map.get();
        if (map != null) {
            map.remove(string);
            m_Log.debug((Object)("URL removed: " + string));
        }
    }
}

