/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.xml;

import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.xml.HugeColProcessor;
import com.elixirtech.data2.datasource.xml.IProcessor;
import com.elixirtech.data2.datasource.xml.IncrementalNamespaceContext;
import com.elixirtech.data2.datasource.xml.XMLDataSource;
import com.elixirtech.jaxen.JaxenException;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.input.SAXHandler;
import java.io.IOException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HugeProcessor
implements IProcessor {
    private XMLDataSource m_DataSource;
    private PushContext m_Context;
    private DataListener m_DataListener;
    private String m_RootXPath;
    private DataSchema m_Schema;
    private XMLDataSource.Column[] m_Columns;
    private HugeColProcessor m_ColProcessor;
    private IncrementalNamespaceContext m_NamespaceContext = new IncrementalNamespaceContext();

    public HugeProcessor(XMLDataSource xMLDataSource, PushContext pushContext, DataListener dataListener) {
        this.m_DataSource = xMLDataSource;
        this.m_Context = pushContext;
        this.m_DataListener = dataListener;
        this.m_RootXPath = this.m_Context.substitute(this.m_DataSource.m_RootXPath);
        this.m_Columns = this.m_DataSource.m_Columns;
        this.m_Schema = this.m_DataSource.m_Schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws RuntimeException {
        try {
            this.m_ColProcessor = new HugeColProcessor(this.m_Context, this.m_DataSource, 0);
            this.m_ColProcessor.setNamespaceContext(this.m_NamespaceContext);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            String string = this.m_Context.substitute(this.m_DataSource.getURL());
            InputSource inputSource = new InputSource(URLLoader.getInputStream(string));
            inputSource.setSystemId(string);
            this.m_DataListener.startData(this.m_DataSource);
            try {
                sAXParser.parse(inputSource, (DefaultHandler)new Handler());
            }
            finally {
                this.m_DataListener.endData(this.m_DataSource);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error reading XML: " + iOException, iOException);
        }
        catch (JaxenException jaxenException) {
            throw new RuntimeException("Error in XPath: " + jaxenException, jaxenException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("Error in parser configuration: " + parserConfigurationException, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("Error reading XML: " + sAXException, sAXException);
        }
    }

    protected void processDocument(Document document) throws RuntimeException, JaxenException {
        Element element = document.getRootElement();
        Object[] objectArray = new Object[this.m_Columns.length];
        this.m_ColProcessor.prepare((IProcessor)this, element, objectArray);
    }

    @Override
    public void processRecord(Object[] objectArray) throws RuntimeException {
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
        DataRecord dataRecord = new DataRecord(this.m_Schema, objectArray2);
        this.m_DataListener.processRecord(dataRecord);
    }

    protected Document buildDocument(Element element) {
        Element element2 = new Element(element.getName(), element.getNamespace());
        element2.setContent(element.cloneContent());
        return new Document(element2);
    }

    protected String contentText(Content content) {
        if (content instanceof Element) {
            return ((Element)content).getText();
        }
        return content.getValue();
    }

    private class Handler
    extends DefaultHandler {
        private Stack<String> m_ElementStack = new Stack();
        private int m_DepthMarker;
        private SAXHandler m_SAXHandler;

        private Handler() {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String string, String string2) throws SAXException {
            HugeProcessor.this.m_NamespaceContext.add(string, string2);
            if (this.m_SAXHandler != null) {
                this.m_SAXHandler.startPrefixMapping(string, string2);
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4;
            this.m_ElementStack.push(string2);
            if (this.m_SAXHandler == null && (string4 = this.buildPath()).equals(HugeProcessor.this.m_RootXPath)) {
                this.m_DepthMarker = this.m_ElementStack.size();
                this.m_SAXHandler = new SAXHandler();
                this.m_SAXHandler.startDocument();
            }
            if (this.m_SAXHandler != null) {
                this.m_SAXHandler.startElement(string, string2, string3, attributes);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.m_SAXHandler != null) {
                this.m_SAXHandler.characters(cArray, n, n2);
            }
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            if (this.m_SAXHandler != null) {
                this.m_SAXHandler.ignorableWhitespace(cArray, n, n2);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            this.m_ElementStack.pop();
            if (this.m_SAXHandler != null) {
                this.m_SAXHandler.endElement(string, string2, string3);
                if (this.m_DepthMarker > this.m_ElementStack.size()) {
                    this.m_SAXHandler.endDocument();
                    try {
                        HugeProcessor.this.processDocument(this.m_SAXHandler.getDocument());
                    }
                    catch (RuntimeException runtimeException) {
                        throw new SAXException(runtimeException);
                    }
                    catch (JaxenException jaxenException) {
                        throw new SAXException(jaxenException);
                    }
                    this.m_SAXHandler = null;
                    this.m_DepthMarker = 0;
                }
            }
        }

        @Override
        public void endPrefixMapping(String string) throws SAXException {
            if (this.m_SAXHandler != null) {
                this.m_SAXHandler.endPrefixMapping(string);
            }
            HugeProcessor.this.m_NamespaceContext.remove(string);
        }

        @Override
        public void endDocument() throws SAXException {
        }

        private String buildPath() {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.m_ElementStack) {
                stringBuilder.append('/');
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }
    }
}

