/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.xml;

import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.datasource.xml.Merge;

public class XMLDataSchema {
    private String m_RootXPath;
    private Column[] m_Columns;

    public XMLDataSchema(int n) {
        this.m_Columns = new Column[n];
        for (int i = 0; i < this.m_Columns.length; ++i) {
            this.m_Columns[i] = new Column();
            this.m_Columns[i].name = "";
            this.m_Columns[i].type = DataType.UNKNOWN;
            this.m_Columns[i].xpath = "";
            this.m_Columns[i].merge = Merge.SPACE;
        }
    }

    public XMLDataSchema(DataSchema dataSchema) {
        this.m_Columns = new Column[dataSchema.getColumnCount()];
        for (int i = 0; i < this.m_Columns.length; ++i) {
            this.m_Columns[i] = new Column();
            this.m_Columns[i].name = dataSchema.getColumnName(i);
            this.m_Columns[i].type = dataSchema.getColumnType(i);
            this.m_Columns[i].xpath = "";
            this.m_Columns[i].merge = Merge.SPACE;
        }
    }

    public int getColumn(String string) {
        for (int i = 0; i < this.m_Columns.length; ++i) {
            if (!string.equals(this.m_Columns[i].name)) continue;
            return i;
        }
        return -1;
    }

    public String getColumnName(int n) {
        return this.m_Columns[n].name;
    }

    public DataType getColumnType(int n) {
        return this.m_Columns[n].type;
    }

    public int getColumnCount() {
        return this.m_Columns.length;
    }

    public Column getColumn(int n) {
        return this.m_Columns[n];
    }

    public String getRootXPath() {
        return this.m_RootXPath;
    }

    public void setRootXPath(String string) {
        this.m_RootXPath = string;
    }

    public static class Column {
        public String name;
        public DataType type;
        public String xpath;
        public Merge merge;
    }
}

