/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.function;

import com.elixirtech.data2.DataType;
import com.elixirtech.data2.DecimalHelper;
import com.elixirtech.data2.function.Function;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DecimalMedian
implements Function {
    private List<BigDecimal> m_Values = new ArrayList<BigDecimal>();

    @Override
    public Object clone() {
        return new DecimalMedian();
    }

    @Override
    public String getName() {
        return "Median";
    }

    @Override
    public void update(Object object) {
        if (object instanceof BigDecimal) {
            this.m_Values.add((BigDecimal)object);
        }
    }

    @Override
    public void update(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof BigDecimal)) continue;
            this.m_Values.add((BigDecimal)objectArray[i]);
        }
    }

    @Override
    public Object getResult() {
        Collections.sort(this.m_Values);
        int n = this.m_Values.size();
        if (n == 0) {
            return null;
        }
        if ((n & 1) == 1) {
            return this.m_Values.get(n / 2);
        }
        int n2 = n / 2;
        BigDecimal bigDecimal = this.m_Values.get(n2 - 1);
        BigDecimal bigDecimal2 = this.m_Values.get(n2);
        return bigDecimal.add(bigDecimal2).divide(new BigDecimal(2), DecimalHelper.MATH_CONTEXT);
    }

    @Override
    public String getResultName(String string) {
        return "Median(" + string + ")";
    }

    @Override
    public DataType getResultType(DataType dataType) {
        return DataType.DECIMAL;
    }

    @Override
    public void reset() {
        this.m_Values.clear();
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass();
    }
}

