/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.function;

import com.elixirtech.data2.DataType;
import com.elixirtech.data2.function.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Median
implements Function {
    private List<Number> m_Values = new ArrayList<Number>();

    @Override
    public Object clone() {
        return new Median();
    }

    @Override
    public String getName() {
        return "Median";
    }

    @Override
    public void update(Object object) {
        if (object instanceof Number) {
            this.m_Values.add((Number)object);
        }
    }

    @Override
    public void update(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Number)) continue;
            this.m_Values.add((Number)objectArray[i]);
        }
    }

    @Override
    public Object getResult() {
        Collections.sort(this.m_Values, new NumberComparator());
        int n = this.m_Values.size();
        if (n == 0) {
            return null;
        }
        if ((n & 1) == 1) {
            return this.m_Values.get(n / 2).doubleValue();
        }
        int n2 = n / 2;
        double d = this.m_Values.get(n2 - 1).doubleValue();
        double d2 = this.m_Values.get(n2).doubleValue();
        return (d + d2) / 2.0;
    }

    @Override
    public String getResultName(String string) {
        return "Median(" + string + ")";
    }

    @Override
    public DataType getResultType(DataType dataType) {
        return DataType.DOUBLE;
    }

    @Override
    public void reset() {
        this.m_Values.clear();
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass();
    }

    private static class NumberComparator
    implements Comparator<Number> {
        private NumberComparator() {
        }

        @Override
        public int compare(Number number, Number number2) {
            double d;
            double d2 = number.doubleValue();
            if (d2 > (d = number2.doubleValue())) {
                return 1;
            }
            if (d2 < d) {
                return -1;
            }
            return 0;
        }
    }
}

