/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.grouping;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.AbstractDataSource;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.GroupNode;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.grouping.GroupBuilder;
import com.elixirtech.data2.grouping.GroupDefinition;
import com.elixirtech.data2.grouping.GrouperFactory;
import com.elixirtech.data2.grouping.TreeBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class GroupDataSource2
extends AbstractDataSource {
    private String m_Name;
    private IDataSource m_DataSource;
    private String m_Description;
    private DataRecord[] m_Records;
    private String m_Extract;
    private GroupNode m_Root;
    private List<GroupDefinition> m_GroupDefinitions = new ArrayList<GroupDefinition>();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(GroupDataSource2.class);
    private static final String EXTRACT = "^(Top|Bottom) ([0-9]+)(%)? Level ([0-9]+)$";
    private static final Pattern PATTERN = GroupDataSource2.buildPattern("^(Top|Bottom) ([0-9]+)(%)? Level ([0-9]+)$");

    public GroupDataSource2(String string, IDataSource iDataSource) {
        this.m_Name = string;
        this.m_DataSource = iDataSource;
        if (this.m_DataSource instanceof DataTable) {
            DataTable dataTable = (DataTable)this.m_DataSource;
            this.m_Records = dataTable.getRecords();
            this.m_Root = dataTable.getGroups();
        }
    }

    public void group(GroupDefinition groupDefinition) {
        this.m_GroupDefinitions.add(groupDefinition);
    }

    public IDataSource getParent() {
        return this.m_DataSource;
    }

    public int getGroupCount() {
        return this.m_GroupDefinitions.size();
    }

    public GroupDefinition getGroup(int n) {
        return this.m_GroupDefinitions.get(n);
    }

    public GroupNode getGroups() {
        return this.m_Root;
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        for (GroupDefinition groupDefinition : this.m_GroupDefinitions) {
            groupDefinition.buildParameters(argumentMap);
        }
        argumentMap.extractParameters(this.m_Extract);
        return argumentMap.getParameters();
    }

    public void doGrouping(PushContext pushContext) {
        int n;
        assert (this.m_Records != null) : "doGrouping has no records available";
        DataSchema dataSchema = this.getSchema();
        int n2 = dataSchema.getColumnCount();
        if (n2 > (n = this.m_DataSource.getSchema().getColumnCount())) {
            this.resizeRecords(dataSchema, n, n2);
        }
        TreeBuilder treeBuilder = new TreeBuilder(this.m_Records);
        for (GroupDefinition groupDefinition : this.m_GroupDefinitions) {
            groupDefinition.resolve(pushContext, dataSchema);
            treeBuilder.process(groupDefinition);
        }
        this.m_Root = treeBuilder.getRoot();
    }

    public void doExtract(PushContext pushContext) {
        if (StringUtil.notEmpty(this.m_Extract)) {
            String string = pushContext.substitute(this.m_Extract);
            Matcher matcher = PATTERN.matcher(string);
            if (matcher.find()) {
                boolean bl = matcher.group(1).equals("Top");
                int n = Integer.parseInt(matcher.group(2));
                boolean bl2 = matcher.group(3) != null;
                int n2 = Integer.parseInt(matcher.group(4));
                this.extract(bl, n, bl2, n2);
            } else {
                m_Log.error((Object)("Can't parse extract string: " + string));
            }
        }
    }

    protected void resizeRecords(DataSchema dataSchema, int n, int n2) {
        for (int i = 0; i < this.m_Records.length; ++i) {
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.m_Records[i].getData(), 0, objectArray, 0, n);
            this.m_Records[i].setData(dataSchema, objectArray);
        }
    }

    protected void extract(boolean bl, int n, boolean bl2, int n2) {
        if (n == 100 && bl2) {
            return;
        }
        if (n > 0) {
            int[] nArray = this.getGroups(n2);
            if (nArray.length > 0) {
                Worker worker = new Worker(bl, n, bl2);
                for (int i = 0; i < nArray.length; i += 2) {
                    this.extract(nArray[i], nArray[i + 1], worker);
                }
                DataRecord[] dataRecordArray = new DataRecord[worker.writePos];
                System.arraycopy(this.m_Records, 0, dataRecordArray, 0, worker.writePos);
                this.m_Records = dataRecordArray;
                ArrayList<GroupNode> arrayList = new ArrayList<GroupNode>();
                this.getGroups(this.m_Root, arrayList);
                for (GroupNode groupNode : arrayList) {
                    for (Range range : worker.removedRanges) {
                        this.removeFromGroups(groupNode, range.start, range.stop);
                    }
                }
            }
        } else {
            this.m_Records = new DataRecord[0];
            this.m_Root = new GroupNode();
            this.m_Root.setStart(0);
            this.m_Root.setStop(-1);
            this.m_Root.setName("");
        }
    }

    protected int[] getGroups(int n) {
        ArrayList<GroupNode> arrayList = new ArrayList<GroupNode>();
        this.buildChildren(this.m_Root, n, arrayList);
        int[] nArray = new int[arrayList.size() * 2];
        Iterator iterator = arrayList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            GroupNode groupNode = (GroupNode)iterator.next();
            nArray[n2++] = groupNode.getStart();
            nArray[n2++] = groupNode.getStop();
        }
        return nArray;
    }

    protected void getGroups(GroupNode groupNode, List<GroupNode> list) {
        list.add(groupNode);
        if (groupNode.hasChildren()) {
            Iterator<GroupNode> iterator = groupNode.getChildIterator();
            while (iterator.hasNext()) {
                this.getGroups(iterator.next(), list);
            }
        }
    }

    protected void buildChildren(GroupNode groupNode, int n, List<GroupNode> list) {
        if (n == 0) {
            list.add(groupNode);
        } else if (groupNode.hasChildren()) {
            Iterator<GroupNode> iterator = groupNode.getChildIterator();
            while (iterator.hasNext()) {
                this.buildChildren(iterator.next(), n - 1, list);
            }
        }
    }

    protected void extract(int n, int n2, Worker worker) {
        int n3 = n2 - n + 1;
        if (n3 > 0) {
            int n4 = worker.amount;
            if (worker.percent) {
                n4 = Math.max(1, n4 * n3 / 100);
            }
            if (n3 <= n4) {
                System.arraycopy(this.m_Records, n, this.m_Records, worker.writePos, n3);
                worker.writePos += n3;
            } else {
                int n5 = 0;
                int n6 = 0;
                if (worker.top) {
                    int n7 = n;
                    System.arraycopy(this.m_Records, n7, this.m_Records, worker.writePos, n4);
                    n5 = n7 + n4;
                    n6 = n2;
                } else {
                    int n8 = n2 - n4 + 1;
                    System.arraycopy(this.m_Records, n8, this.m_Records, worker.writePos, n4);
                    n5 = n;
                    n6 = n8 - 1;
                }
                worker.removedRanges.add(0, new Range(n5, n6));
                worker.writePos += n4;
            }
        }
    }

    protected void removeFromGroups(GroupNode groupNode, int n, int n2) {
        if (groupNode.getStop() < n) {
            return;
        }
        if (groupNode.getStart() > n2) {
            int n3 = n2 - n + 1;
            groupNode.setStart(groupNode.getStart() - n3);
            groupNode.setStop(groupNode.getStop() - n3);
        } else if (groupNode.getStart() >= n && groupNode.getStop() <= n2) {
            groupNode.getParent().removeGroup(groupNode);
        } else if (groupNode.getStart() <= n) {
            int n4 = Math.min(groupNode.getStop(), n2) - n + 1;
            groupNode.setStop(groupNode.getStop() - n4);
        } else if (groupNode.getStop() >= n2) {
            int n5 = n2 - n + 1;
            groupNode.setStart(n);
            groupNode.setStop(groupNode.getStop() - n5);
        } else {
            m_Log.warn((Object)("Should never happen: removeFromGroups(" + n + "," + n2 + ") where node start = " + groupNode.getStart() + " stop = " + groupNode.getStop()));
        }
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public void setDescription(String string) {
        this.m_Description = string;
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    @Override
    public String getType() {
        return "Group";
    }

    public void setExtract(String string) {
        this.m_Extract = string;
    }

    public String getExtract() {
        return this.m_Extract;
    }

    @Override
    public DataSchema getSchema() {
        DataSchema dataSchema = this.m_DataSource.getSchema();
        SchemaBuilder schemaBuilder = new SchemaBuilder(dataSchema);
        for (GroupDefinition groupDefinition : this.m_GroupDefinitions) {
            int n;
            String string = groupDefinition.getDerivedFieldName();
            if (!StringUtil.notEmpty(string) || (n = dataSchema.getColumnIndex(groupDefinition.getName())) < 0) continue;
            DataType dataType = dataSchema.getColumnType(n);
            DataType dataType2 = GrouperFactory.getGroupType(groupDefinition.getGroupOn(), dataType);
            schemaBuilder.add(string, dataType2, new DataAttributes());
        }
        return schemaBuilder.getSchema();
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        if (this.m_DataSource instanceof DataTable) {
            DataTable dataTable = (DataTable)this.m_DataSource;
            this.m_Records = dataTable.getRecords();
            this.m_Root = dataTable.getGroups();
            if (this.m_GroupDefinitions.size() == 0) {
                this.pushFlat(pushContext, dataListener);
            } else {
                this.pushTree(pushContext, dataListener);
            }
        } else {
            GroupBuilder groupBuilder = new GroupBuilder(this, pushContext, dataListener);
            this.m_DataSource.pushTo(pushContext, groupBuilder);
        }
    }

    protected void pushFlat(PushContext pushContext, DataListener dataListener) {
        this.doExtract(pushContext);
        dataListener.startData(this);
        for (int i = 0; i < this.m_Records.length && dataListener.processRecord(this.m_Records[i]); ++i) {
        }
        dataListener.endData(this);
    }

    protected void pushTree(PushContext pushContext, DataListener dataListener) {
        this.doGrouping(pushContext);
        this.doExtract(pushContext);
        dataListener.startData(this);
        if (this.m_Root.hasChildren()) {
            Iterator<GroupNode> iterator = this.m_Root.getChildIterator();
            while (iterator.hasNext() && this.processNode(iterator.next(), dataListener)) {
            }
        } else {
            for (int i = 0; i < this.m_Records.length && dataListener.processRecord(this.m_Records[i]); ++i) {
            }
        }
        dataListener.endData(this);
    }

    protected void proceed(GroupBuilder groupBuilder) {
        DataTable dataTable = groupBuilder.getTable();
        this.m_Records = dataTable.getRecords();
        this.m_Root = dataTable.getGroups();
        PushContext pushContext = groupBuilder.getPushContext();
        DataListener dataListener = groupBuilder.getDataListener();
        if (this.m_GroupDefinitions.size() == 0) {
            this.pushFlat(pushContext, dataListener);
        } else {
            this.pushTree(pushContext, dataListener);
        }
    }

    protected boolean processNode(GroupNode groupNode, DataListener dataListener) {
        boolean bl = true;
        dataListener.startGroup(groupNode);
        if (groupNode.hasChildren()) {
            Iterator<GroupNode> iterator = groupNode.getChildIterator();
            while (iterator.hasNext()) {
                if (this.processNode(iterator.next(), dataListener)) continue;
                bl = false;
                break;
            }
        } else {
            for (int i = groupNode.getStart(); i <= groupNode.getStop(); ++i) {
                if (dataListener.processRecord(this.m_Records[i])) continue;
                bl = false;
                break;
            }
        }
        dataListener.endGroup(groupNode);
        return bl;
    }

    static Pattern buildPattern(String string) {
        try {
            return Pattern.compile(EXTRACT);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            m_Log.error((Object)"Can't initialize extract pattern");
            return null;
        }
    }

    private static class Worker {
        public int writePos;
        public boolean top;
        public int amount;
        public boolean percent;
        public List<Range> removedRanges = new ArrayList<Range>();

        public Worker(boolean bl, int n, boolean bl2) {
            this.top = bl;
            this.amount = n;
            this.percent = bl2;
        }
    }

    private static class Range {
        public int start;
        public int stop;

        public Range(int n, int n2) {
            this.start = n;
            this.stop = n2;
        }
    }
}

